<div x-data="{ perfil: false }" class="flex items-center md:order-2">
    <button @click="perfil = ! perfil" type="button"
        class="hidden mr-3 text-sm bg-gray-800 rounded-full md:block md:mr-0 focus:ring-4 focus:ring-gray-300 dark:focus:ring-gray-600"
        id="user-menu-button" aria-expanded="false" data-dropdown-toggle="user-dropdown"
        data-dropdown-placement="bottom">
        <span class="sr-only">Open user menu</span>
        <img class="w-8 h-8 rounded-full" src="https://cdn-icons-png.flaticon.com/512/3135/3135768.png"
            alt="user photo">
    </button>
    <button @click="perfil = ! perfil" type="button"
        class="block py-2 pl-3 pr-4 text-gray-700 border-b border-gray-100 md:hidden hover:bg-gray-50 md:hover:bg-transparent md:border-0 md:hover:text-blue-700 md:p-0 dark:text-gray-400 md:dark:hover:text-blue-500 dark:hover:bg-gray-700 dark:hover:text-blue-500 md:dark:hover:bg-transparent dark:border-gray-700">
        PERFIL
    </button>
    <!-- Dropdown menu -->
    <div x-show="perfil" x-on:click.away="perfil = false"
        class="absolute z-40 block my-4 text-base list-none bg-white divide-y divide-gray-100 rounded shadow dark:bg-gray-700 dark:divide-gray-600 top-10 right-6 ">
        <div class="px-4 py-3">
            <span class="block text-sm text-gray-900 capitalize dark:text-white">
                <?php echo e(Auth::user()->name); ?>

            </span>
            <span class="block text-sm font-medium text-gray-500 truncate dark:text-gray-400">
                <?php if( Auth::user()->type == '0'): ?>
                Mecanico
                <?php elseif(Auth::user()->type == '1'): ?>
                Administración
                <?php else: ?>
                Administrador
                <?php endif; ?>
            </span>
        </div>
        <ul class="py-1" aria-labelledby="user-menu-button">
            <li>
                <a href="<?php echo e(route('user.profile')); ?>"
                    class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100 dark:hover:bg-gray-600 dark:text-gray-200 dark:hover:text-white">Perfil</a>
            </li>
            <li>

                <form action="<?php echo e(route('login.singOut')); ?>" method="post">
                    <?php echo csrf_field(); ?>
                    <button type="submit"
                        class="block w-full px-4 py-2 text-sm text-left text-gray-700 hover:bg-gray-100 dark:hover:bg-gray-600 dark:text-gray-200 dark:hover:text-white">
                        Cerrar Sesión
                    </button>
                </form>
            </li>
        </ul>
    </div>
</div>
<?php /**PATH /home/syscodec/public_html/Developer/mecanic_system/resources/views/nav/perfil-nav.blade.php ENDPATH**/ ?>