<?php $__env->startComponent('app'); ?>
    <!-- This example requires Tailwind CSS v2.0+ -->
    <?php if(session('message')): ?>
        <div class="bg-indigo-600">
            <div class="px-3 py-3 mx-auto max-w-7xl sm:px-6 lg:px-8">
                <div class="flex flex-wrap items-center justify-between">
                    <div class="flex items-center flex-1 w-0">
                        <span class="flex p-2 bg-indigo-800 rounded-lg">}
                            <svg class="w-6 h-6 text-white" xmlns="http://www.w3.org/2000/svg" fill="none"
                                viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" aria-hidden="true">
                                <path stroke-linecap="round" stroke-linejoin="round"
                                    d="M11 5.882V19.24a1.76 1.76 0 01-3.417.592l-2.147-6.15M18 13a3 3 0 100-6M5.436 13.683A4.001 4.001 0 017 6h1.832c4.1 0 7.625-1.234 9.168-3v14c-1.543-1.766-5.067-3-9.168-3H7a3.988 3.988 0 01-1.564-.317z" />
                            </svg>
                        </span>
                        <p class="ml-3 font-medium text-white truncate">
                            <span class="">
                                <?php echo e(session('message')); ?> </span>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <!-- component -->
    <div class="flex flex-col-reverse items-center justify-center p-20 md:flex-row ">
        <div class="text-3xl text-center content md:text-left">
            <h1 class="text-5xl font-bold text-blue-500">
                LISAC MOTORS
            </h1>
            <p class="text-lg">
                Taller Automotriz
            </p>
        </div>
        <div class="container flex flex-col items-center mx-auto">
            <form action="<?php echo e(route('login.singIn')); ?>" method="POST"
                class="flex flex-col p-4 bg-white rounded-lg shadow-lg w-80">
                <?php echo csrf_field(); ?>
                <input type="text" name="email" autocomplete="off" placeholder="Usuario"
                    class="px-4 py-3 mb-3 border border-gray-400 rounded-md focus:outline-none focus:ring-1 ring-cyan-500" />
                <input type="password" name="password" autocomplete="off" placeholder="Contraseña"
                    class="px-4 py-3 mb-3 border border-gray-400 rounded-md focus:outline-none focus:ring-1 ring-cyan-500" />
                <button type="submit" class="w-full p-3 text-lg font-semibold text-white bg-blue-500 rounded-lg">
                    INGRESAR
                </button>
            </form>
            <p class="my-4 text-sm text-center">
                <span class="w-full font-semibold text-center">
                </span>
            </p>
        </div>
    </div>
<?php echo $__env->renderComponent(); ?>
<?php /**PATH C:\laragon\www\MECANIC-SYSTEM\resources\views/login.blade.php ENDPATH**/ ?>