<?php

use App\Http\Controllers\LoginController;
use App\Http\Controllers\PDFController;
use App\Http\Livewire\Bank\IndexBank;
use App\Http\Livewire\Box\IndexBox;
use App\Http\Livewire\Calculate\IndexCalculate;
use App\Http\Livewire\Calculate\ShowCalculate;
use App\Http\Livewire\Car\IndexCar;
use App\Http\Livewire\Client\IndexClient;
use App\Http\Livewire\Mecanic\IndexMecanic;
use App\Http\Livewire\Mecanic\ShowMecanic;
use App\Http\Livewire\Product\IndexProduct;
use App\Http\Livewire\Report\IndexReport;
use App\Http\Livewire\Sale\IndexSale;
use App\Http\Livewire\Sale\ShowSale;
use App\Http\Livewire\Service\IndexService;
use App\Http\Livewire\User\IndexUser;
use App\Http\Livewire\User\PerfilUser;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Route;

Route::get('storage-link', function () {
    Artisan::call('storage:link');
});

Route::get('/', function () {
    return view('home');
});
Route::get('home', function () {
    return view('home');
})->name('home');
// Login
Route::get('login', [LoginController::class, 'login'])->name('login')->middleware('guest');
Route::post('login', [LoginController::class, 'singIn'])->name('login.singIn');
Route::post('logout', [LoginController::class, 'singOut'])->name('login.singOut');
// Perfil
Route::get('perfil', PerfilUser::class)->name('user.profile')->middleware('auth');
// Servicios
Route::get('servicios', IndexService::class)->name('services.index')->middleware('auth');
// Productos
Route::get('productos', IndexProduct::class)->name('products.index')->middleware('auth');
// Clientes
Route::get('clientes', IndexClient::class)->name('clients.index')->middleware('auth');
// Vehiculos
Route::get('vehiculos', IndexCar::class)->name('cars.index')->middleware('auth');
// Cuentas
Route::get('cuentas', IndexBank::class)->name('banks.index')->middleware('auth');
// Caja
Route::get('caja', IndexBox::class)->name('box.index')->middleware('auth');
// Usuarios
Route::get('usuarios', IndexUser::class)->name('user.index')->middleware('auth');
// Ventas
Route::get('ventas', IndexSale::class)->name('sale.index')->middleware('auth');
Route::get('ventas/{sale}', ShowSale::class)->name('sale.show')->middleware('auth');
// Reportes PDF
Route::get('pdf_sale/{sale}', [PDFController::class, 'pdfSale'])->name('pdf.sale')->middleware('auth');
Route::get('pdf_calculate/{calculate}', [PDFController::class, 'pdfCalculate'])->name('pdf.calculate')->middleware('auth');
// Mecanico
Route::get('mecanico', IndexMecanic::class)->name('mecanic.index')->middleware('auth');
Route::get('mecanico/{sale}', ShowMecanic::class)->name('mecanic.show')->middleware('auth');
// Cotizaciones
Route::get('cotizaciones', IndexCalculate::class)->name('calculate.index')->middleware('auth');
Route::get('cotizaciones/{calculate}', ShowCalculate::class)->name('calculate.show')->middleware('auth');
// Reportes
Route::get('reportes', IndexReport::class)->name('report.index')->middleware('auth');
