<div>
    {{-- Buscador --}}
    <div class="p-4 text-right">
        <label for="create" type="button"
            class="ml-2 cursor-pointer text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:ring-blue-300 font-medium rounded-lg text-sm px-5 py-2.5 mr-2 mb-2 dark:bg-blue-600 dark:hover:bg-blue-700 focus:outline-none dark:focus:ring-blue-800">
            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"
                xmlns="http://www.w3.org/2000/svg">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                    d="M17 14v6m-3-3h6M6 10h2a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v2a2 2 0 002 2zm10 0h2a2 2 0 002-2V6a2 2 0 00-2-2h-2a2 2 0 00-2 2v2a2 2 0 002 2zM6 20h2a2 2 0 002-2v-2a2 2 0 00-2-2H6a2 2 0 00-2 2v2a2 2 0 002 2z">
                </path>
            </svg>
        </label>
    </div>
    {{-- Tabla --}}
    <div class="relative overflow-x-auto shadow-md sm:rounded-lg">
        <table class="w-full text-sm text-left text-gray-500 dark:text-gray-400">
            <thead class="text-xs text-gray-700 uppercase bg-gray-50 dark:bg-gray-700 dark:text-gray-400">
                <tr>
                    <th scope="col" class="px-6 py-3">
                        NOMBRES COMPLETOS
                    </th>
                    <th scope="col" class="px-6 py-3">
                        USUARIO
                    </th>
                    <th scope="col" class="px-6 py-3 ">
                        TIPO
                    </th>
                    <th scope="col" class="px-6 py-3 text-center">
                        ESTADO
                    </th>
                    <th scope="col" class="px-6 py-3">
                        <span class="sr-only">Edit</span>
                    </th>
                </tr>
            </thead>
            <tbody>
                @foreach ($users as $item)
                <tr
                    class="bg-white border-b dark:bg-gray-800 dark:border-gray-700 hover:bg-gray-50 dark:hover:bg-gray-600">
                    <th scope="row"
                        class="px-6 py-4 font-medium text-gray-900 capitalize dark:text-white whitespace-nowrap">
                        {{$item->name}}
                    </th>
                    <td class="px-6 py-4">
                        {{$item->email}}
                    </td>
                    <td class="px-6 py-4 ">
                        @switch($item->type)
                        @case('0')
                        MECANICO
                        @break
                        @case('1')
                        OFICINA
                        @break
                        @case('2')
                        ADMINISTRADOR
                        @break

                        @default

                        @endswitch
                    </td>
                    <td class="px-6 py-4 text-center">
                        @if($item->status == '1')
                        <span class="px-2 py-1 font-semibold leading-tight text-green-700 bg-green-100 rounded-sm">
                            ACTIVO
                        </span>
                        @else
                        <span class="px-2 py-1 font-semibold leading-tight text-red-700 bg-red-100 rounded-sm">
                            SUSPENDIDO
                        </span>

                        @endif
                    </td>
                    <td class="flex px-6 py-4 text-center">
                        <button type="button" wire:click="questionReset({{ $item }})"
                            class="p-2 mb-2 ml-2 mr-2 text-sm font-medium text-white bg-yellow-400 rounded-lg hover:bg-yellow-400 focus:ring-4 focus:ring-yellow-400 dark:bg-yellow-400 dark:hover:bg-yellow-400 focus:outline-none dark:focus:ring-yellow-400">
                            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"
                                xmlns="http://www.w3.org/2000/svg">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M15 7a2 2 0 012 2m4 0a6 6 0 01-7.743 5.743L11 17H9v2H7v2H4a1 1 0 01-1-1v-2.586a1 1 0 01.293-.707l5.964-5.964A6 6 0 1121 9z">
                                </path>
                            </svg>
                        </button>
                        <label wire:click="$set('user',{{ $item }})" for="edit" type="button"
                            class="p-2 mb-2 ml-2 mr-2 text-sm font-medium text-white bg-green-700 rounded-lg cursor-pointer hover:bg-green-800 focus:ring-4 focus:ring-green-300 dark:bg-green-600 dark:hover:bg-green-700 focus:outline-none dark:focus:ring-green-800">
                            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"
                                xmlns="http://www.w3.org/2000/svg">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z">
                                </path>
                            </svg>
                        </label>
                        <button wire:click="question({{ $item }})" type="button"
                            class="p-2 mb-2 ml-2 mr-2 text-sm font-medium text-white rounded-lg bg-rose-700 hover:bg-rose-800 focus:ring-4 focus:ring-rose-300 dark:bg-rose-600 dark:hover:bg-rose-700 focus:outline-none dark:focus:ring-rose-800">
                            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"
                                xmlns="http://www.w3.org/2000/svg">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M15 12H9m12 0a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                        </button>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>


    {{-- Modal Create --}}
    <input type="checkbox" id="create" class="modal-toggle" />
    <div class="modal">
        <div class="w-11/12 max-w-5xl modal-box">
            <label for="create" class="absolute btn btn-sm btn-circle right-2 top-2">✕</label>
            @livewire('user.create-user')
        </div>
    </div>

    {{-- Modal Edit --}}

    <input type="checkbox" id="edit" class="modal-toggle" />
    <div class="modal">
        <div class="w-11/12 max-w-5xl modal-box">
            <label wire:click="$set('user', null)" for="edit"
                class="absolute btn btn-sm btn-circle right-2 top-2">✕</label>
            {{-- Content Edit --}}
            @if($user)
            @livewire('user.edit-user',['user'=>$user])
            @else
            @include('components.load')
            @endif
            {{-- End Content --}}
        </div>
    </div>
</div>
