<div>

    <form wire:submit.prevent='update'>
        <div class="mb-6">
            <label class="block mb-2 text-sm font-medium text-gray-900 dark:text-gray-300">
                Nombres Completos
            </label>
            <input wire:model='name' type="text" autocomplete="off"
                class="capitalize bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 focus:outline-none dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
            @error('name')
            <span class="error">{{ $message }}</span>
            @enderror
        </div>
        <div class="mb-6">
            <label class="block mb-2 text-sm font-medium text-gray-900 dark:text-gray-300">
                Nombre de Usuario
            </label>
            <input wire:model="email" type="text"
                class="focus:outline-none bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500"
                placeholder="Ingresar DNI">
            @error('email')
            <span class="error">{{ $message }}</span>
            @enderror
        </div>
        <div class="mb-6">
            <div>
                <label for="" class="block text-sm font-medium text-gray-700">
                    Tipo de Personal
                </label>
                <select wire:model='type' id="" name="country" autocomplete="country-name"
                    class="block w-full px-3 py-2 mt-1 font-medium text-indigo-700 bg-white border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm">
                    <option value='0' class="font-bold text-green-700">MECANICO</option>
                    <option value='1' class="font-bold text-red-700">SECRETARIA</option>
                    <option value='2' class="font-bold text-indigo-700">ADMINISTRADOR</option>
                </select>
            </div>
        </div>
        <div class="mb-6">
            <div>
                <label class="block text-sm font-medium text-gray-700">
                    ESTADO
                </label>
                <select wire:model='status' id="" name="country" autocomplete="country-name"
                    class="block w-full px-3 py-2 mt-1 font-medium text-indigo-700 bg-white border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm">
                    <option value='1' class="font-bold text-green-700">ACTIVO</option>
                    <option value='0' class="font-bold text-red-700">SUPENDIDO</option>
                </select>
            </div>
        </div>
        <button type="submit"
            class="text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 font-medium rounded-lg text-sm w-full sm:w-auto px-5 py-2.5 text-center dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
            ACTUALIZAR</button>
    </form>

</div>
