<div>
    {{-- Nav --}}
    <div class="border-b border-gray-200 dark:border-gray-700">
        <ul class="flex flex-wrap -mb-px text-sm font-medium text-center text-gray-500 dark:text-gray-400">
            <li class="mr-2">
                <label for="product"
                    class="inline-flex p-4 text-blue-600 border-b-2 border-blue-600 rounded-t-lg cursor-pointer active dark:text-blue-500 dark:border-blue-500 group"
                    aria-current="page">
                    <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"
                        xmlns="http://www.w3.org/2000/svg">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"></path>
                    </svg>PRODUCTOS
                </label>
            </li>
            <li class="mr-2">
                <label for="service"
                    class="inline-flex p-4 text-blue-600 border-b-2 border-blue-600 rounded-t-lg cursor-pointer active dark:text-blue-500 dark:border-blue-500 group"
                    aria-current="page">
                    <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 mr-2 icon icon-tabler icon-tabler-tool"
                        viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round"
                        stroke-linejoin="round">
                        <desc>Download more icon variants from https://tabler-icons.io/i/tool</desc>
                        <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                        <path d="M7 10h3v-3l-3.5 -3.5a6 6 0 0 1 8 8l6 6a2 2 0 0 1 -3 3l-6 -6a6 6 0 0 1 -8 -8l3.5 3.5">
                        </path>
                    </svg>SERVICIOS
                </label>
            </li>
            <li class="mr-2">
                <label for="advance"
                    class="inline-flex p-4 text-blue-600 border-b-2 border-blue-600 rounded-t-lg cursor-pointer active dark:text-blue-500 dark:border-blue-500 group"
                    aria-current="page">
                    <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"
                        xmlns="http://www.w3.org/2000/svg">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2zm7-5a2 2 0 11-4 0 2 2 0 014 0z">
                        </path>
                    </svg>ADELANTOS
                </label>
            </li>
            <li class="mr-2 dropdown">
                <label tabindex="0"
                    class="inline-flex p-4 text-blue-600 border-b-2 border-blue-600 rounded-t-lg cursor-pointer active dark:text-blue-500 dark:border-blue-500 group"
                    aria-current="page">
                    <svg class="w-5 h-5 " fill="none" stroke="currentColor" viewBox="0 0 24 24"
                        xmlns="http://www.w3.org/2000/svg">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M15.232 5.232l3.536 3.536m-2.036-5.036a2.5 2.5 0 113.536 3.536L6.5 21.036H3v-3.572L16.732 3.732z">
                        </path>
                    </svg>
                </label>
                <ul tabindex="0" class="p-2 shadow dropdown-content menu bg-base-100 rounded-box w-52">
                    <div class="mb-6">
                        <label class="block mb-2 text-sm font-medium text-gray-900 dark:text-gray-300">
                            Descripción
                        </label>
                        <input wire:model='order_description' type="input" autocomplete="off"
                            class="capitalize bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 focus:outline-none dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
                    </div>
                    <div class="mb-6">
                        <label class="block mb-2 text-sm font-medium text-gray-900 dark:text-gray-300">
                            Servicio ó Producto
                        </label>

                        <select wire:model="order_type"
                            class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 focus:outline-none dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
                            <option value="Servicio">Servicio</option>
                            <option value="Producto">Producto</option>
                        </select>
                    </div>
                    <button wire:click="addOrder" type="button"
                        class="text-white bg-red-700 hover:bg-red-800 focus:ring-4 focus:outline-none focus:ring-red-300 font-medium rounded-lg text-sm w-full sm:w-auto px-5 py-2.5 text-center dark:bg-red-600 dark:hover:bg-red-700 dark:focus:ring-red-800">
                        AGREGAR ORDEN
                    </button>
                </ul>
            </li>
            <li class="mr-2">
                <label for="report"
                    class="inline-flex p-4 text-blue-600 border-b-2 border-blue-600 rounded-t-lg cursor-pointer active dark:text-blue-500 dark:border-blue-500 group"
                    aria-current="page">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"
                        xmlns="http://www.w3.org/2000/svg">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-3 7h3m-3 4h3m-6-4h.01M9 16h.01">
                        </path>
                    </svg>
                </label>
            </li>


            <li class="mr-2">
                <label wire:click='questionPay'
                    class="inline-flex p-4 text-green-600 border-b-2 border-green-600 rounded-t-lg cursor-pointer active dark:text-green-500 dark:border-green-500 group"
                    aria-current="page">
                    <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"
                        xmlns="http://www.w3.org/2000/svg">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M15 15l-2 5L9 9l11 4-5 2zm0 0l5 5M7.188 2.239l.777 2.897M5.136 7.965l-2.898-.777M13.95 4.05l-2.122 2.122m-5.657 5.656l-2.12 2.122">
                        </path>
                    </svg>
                    PAGAR
                </label>
            </li>
            <li class="mr-2 dropdown">
                <label tabindex="0"
                    class="inline-flex p-4 text-green-600 border-b-2 border-green-600 rounded-t-lg cursor-pointer active dark:text-green-500 dark:border-green-500 group"
                    aria-current="page">
                    <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"
                        xmlns="http://www.w3.org/2000/svg">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M10 14H5.236a2 2 0 01-1.789-2.894l3.5-7A2 2 0 018.736 3h4.018a2 2 0 01.485.06l3.76.94m-7 10v5a2 2 0 002 2h.096c.5 0 .905-.405.905-.904 0-.715.211-1.413.608-2.008L17 13V4m-7 10h2m5-10h2a2 2 0 012 2v6a2 2 0 01-2 2h-2.5">
                        </path>
                    </svg>
                    DEUDA
                </label>
                <ul tabindex="0" class="p-2 shadow dropdown-content menu bg-base-100 rounded-box w-52">
                    <div class="mb-6">
                        <label class="block mb-2 text-sm font-medium text-gray-900 dark:text-gray-300">
                            Fecha de Pago
                        </label>
                        <input wire:model='date_debt' type="date" autocomplete="off"
                            class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 focus:outline-none dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
                    </div>
                    <button wire:click="debt" type="button"
                        class="text-white bg-red-700 hover:bg-red-800 focus:ring-4 focus:outline-none focus:ring-red-300 font-medium rounded-lg text-sm w-full sm:w-auto px-5 py-2.5 text-center dark:bg-red-600 dark:hover:bg-red-700 dark:focus:ring-red-800">
                        PONER COMO DEUDA
                    </button>
                </ul>
            </li>
            <li class="mr-2">
                <label wire:click='questionCancel'
                    class="inline-flex p-4 text-green-600 border-b-2 border-green-600 rounded-t-lg cursor-pointer active dark:text-green-500 dark:border-green-500 group"
                    aria-current="page">
                    <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"
                        xmlns="http://www.w3.org/2000/svg">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12">
                        </path>
                    </svg>
                    CANCELAR
                </label>
            </li>
            <li class="mr-2">
                <a href="{{ route('pdf.sale', $sale) }}" target="_blank"
                    class="inline-flex p-4 text-green-600 border-b-2 border-green-600 rounded-t-lg cursor-pointer active dark:text-green-500 dark:border-green-500 group"
                    aria-current="page">
                    <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"
                        xmlns="http://www.w3.org/2000/svg">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M17 17h2a2 2 0 002-2v-4a2 2 0 00-2-2H5a2 2 0 00-2 2v4a2 2 0 002 2h2m2 4h6a2 2 0 002-2v-4a2 2 0 00-2-2H9a2 2 0 00-2 2v4a2 2 0 002 2zm8-12V5a2 2 0 00-2-2H9a2 2 0 00-2 2v4h10z">
                        </path>
                    </svg>
                    IMPRIMIR
                </a>
            </li>
            <li class="mr-2">
                <label wire:click="update"
                    class="inline-flex p-4 text-green-600 border-b-2 border-green-600 rounded-t-lg cursor-pointer active dark:text-green-500 dark:border-green-500 group"
                    aria-current="page">
                    <svg class="w-5 h-5 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24"
                        xmlns="http://www.w3.org/2000/svg">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15">
                        </path>
                    </svg>
                    ACTUALIZAR
                </label>
            </li>
        </ul>
    </div>
    {{-- Modelo de Venta --}}
    <div id="bolet" class="select-none font">
        {{-- Datos de la venta --}}
        <div class="grid grid-cols-12 mt-2 ">

            <div class="col-span-12 text-center border border-indigo-600">
                <label class="font-bold text-blue-600">
                    DATOS DE LA VENTA
                </label>
            </div>

            <div class="col-span-3 pl-3 border-b border-l border-r border-indigo-600">
                <label class="font-bold text-blue-600">ESTADO: </label>
                <label class="font-bold text-black uppercase"> {{ $sale->Condition->description }}</label>
            </div>
            <div class="col-span-3 pl-3 border-b border-r border-indigo-600">
                <label class="font-bold text-blue-600">N° VENTA: </label>
                <label class="font-bold text-green-600 uppercase"> {{str_pad($sale->id, 6, "0", STR_PAD_LEFT) }}</label>
            </div>

            <div class="col-span-3 pl-3 border-b border-l border-r border-indigo-600">
                <div class="dropdown">
                    <label tabindex="0"
                        class="font-bold text-blue-600 cursor-pointer hover:bg-green-600 hover:text-white">
                        M. PAGO:
                    </label>
                    <label class="font-bold text-green-600 uppercase">
                        {{ $sale->BankAccount->name }}
                    </label>

                    <ul tabindex="0" class="p-2 shadow dropdown-content menu bg-base-100 rounded-box w-52">
                        <div class="mb-6">
                            <label class="block mb-2 text-sm font-medium text-gray-900 dark:text-gray-300">
                                Método de Pago
                            </label>
                            <select wire:model="bank_account_id" id="countries"
                                class="capitalize font-bold bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
                                @foreach ($banks as $bank )
                                <option value={{ $bank->id }}>{{ $bank->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <button wire:click="changePayment" type="button"
                            class="text-white bg-red-700 hover:bg-red-800 focus:ring-4 focus:outline-none focus:ring-red-300 font-medium rounded-lg text-sm w-full sm:w-auto px-5 py-2.5 text-center dark:bg-red-600 dark:hover:bg-red-700 dark:focus:ring-red-800">
                            CAMBIAR</button>
                    </ul>
                </div>
            </div>
            <div class="col-span-3 pl-3 border-b border-r border-indigo-600">
                <div class="dropdown">
                    <label tabindex="0"
                        class="font-bold text-blue-600 cursor-pointer hover:bg-red-600 hover:text-white">DESCUENTO:
                    </label>
                    <label class="font-bold text-red-600 uppercase"> -S/ {{ $total_discount_sale }}</label>

                    <ul tabindex="0" class="p-2 shadow dropdown-content menu bg-base-100 rounded-box w-52">
                        <div class="mb-6">
                            <label class="block mb-2 text-sm font-medium text-gray-900 dark:text-gray-300">
                                Monto de Descuento
                            </label>
                            <input wire:model='discount' type="number" step="0.01" autocomplete="off"
                                class="capitalize bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 focus:outline-none dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
                        </div>
                        <button wire:click="discountSale" type="button"
                            class="text-white bg-red-700 hover:bg-red-800 focus:ring-4 focus:outline-none focus:ring-red-300 font-medium rounded-lg text-sm w-full sm:w-auto px-5 py-2.5 text-center dark:bg-red-600 dark:hover:bg-red-700 dark:focus:ring-red-800">
                            DESCONTAR</button>
                    </ul>
                </div>
            </div>



        </div>
        {{-- Header --}}
        <div class="grid grid-cols-12 ">
            <div class="col-span-2 text-center ">
                <img class="w-24 h-24" src="{{ asset('img/logo.png') }}" alt="">
            </div>
            <div class="col-span-10 pr-2 text-right">
                <div>
                    <label class="text-2xl font-bold">ORDEN DE REPARACIÓN</label> <br>
                    <label class="text-xl font-bold text-red-600">
                        N° {{
                        str_pad($sale->id, 6, "0", STR_PAD_LEFT); }}
                    </label>
                </div>
                <p class="text-xs text-left">
                    Servicio de reparación y mantenimiento en general de gasolinera y diesel, maquinarias pesadas,
                    electricidad
                    y electrónica
                    soldadura autógena y eléctrica venta de repuestos y lubricantes en todas marcas, venta de
                    filtros
                    nacionales
                    e importados. <br>
                    <label class="font-bold">DE: Lido Salazar Córdova</label>
                </p>
            </div>
        </div>
        {{-- Datos del Conductor --}}
        <div class="grid grid-cols-12 mt-3">
            <div class="col-span-4 text-center border-t border-l border-r border-indigo-600">
                <label class="font-bold text-blue-600">Fecha de Ingreso: </label>
                <label class="font-bold">{{ $sale->created_at->format('d-m-Y') }}</label>
            </div>
            <div class="col-span-4 text-center border-t border-indigo-600">

            </div>
            <div class="col-span-4 text-center border-t border-l border-r border-indigo-600">
                <label class="font-bold text-blue-600">Fecha de Salida: </label>
                <label class="font-bold">{{ $sale->updated_at->format('d-m-Y') }}</label>
            </div>
            <div class="col-span-12 text-center border border-indigo-600">
                <label class="font-bold text-blue-600">DATOS DEL RECEPTOR / CONDUCTOR</label>
            </div>

            <div class="col-span-6 pl-3 border-b border-l border-r border-indigo-600">
                <label class="font-bold text-blue-600">Propietario: </label>
                <label class="font-bold capitalize">{{ $car->Client->names }}</label>
            </div>

            <div class="col-span-6 pl-3 border-b border-r border-indigo-600">
                <label class="font-bold text-blue-600">Conductor: </label>
                <label class="font-bold capitalize">{{ $client->names }}</label>
            </div>

            <div class="col-span-6 pl-3 uppercase border-b border-l border-r border-indigo-600">
                <label class="font-bold text-blue-600">R.U.C: </label>
                <label class="font-bold">{{ $car->Client->ruc }}</label>
            </div>

            <div class="col-span-6 pl-3 uppercase border-b border-r border-indigo-600">
                <label class="font-bold text-blue-600">D.N.I: </label>
                <label class="font-bold">{{ $client->dni }}</label>
            </div>

            <div class="col-span-6 pl-3 border-b border-l border-r border-indigo-600">
                <label class="font-bold text-blue-600">Teléfono: </label>
                <label class="font-bold uppercase">{{ $car->Client->phone }}</label>
            </div>

            <div class="col-span-6 pl-3 border-b border-r border-indigo-600">
                <label class="font-bold text-blue-600">Celular: </label>
                <label class="font-bold uppercase">{{ $client->phone }}</label>
            </div>

            <div class="col-span-12 pl-3 border-b border-l border-r border-indigo-600">
                <label class="font-bold text-blue-600">Dirección: </label>
                <label class="font-bold capitalize">{{ $car->Client->address }}</label>
            </div>



        </div>

        {{-- Datos del Vehículo --}}
        <div class="grid grid-cols-12 mt-3">
            <div class="col-span-12 text-center border border-indigo-600">
                <label class="font-bold text-blue-600">
                    DATOS DEL VEHÍCULO
                </label>
            </div>

            <div class="col-span-4 pl-3 border-b border-l border-r border-indigo-600">
                <label class="font-bold text-blue-600">Placa: </label>
                <label class="font-bold uppercase">{{ $car->plate }}</label>
            </div>

            <div class="col-span-4 pl-3 border-b border-r border-indigo-600">
                <label class="font-bold text-blue-600">N° Motor: </label>
                <label class="font-bold uppercase">{{ $car->engine }}</label>
            </div>
            <div class="col-span-4 pl-3 border-b border-r border-indigo-600">
                <label class="font-bold text-blue-600">N° Chasis: </label>
                <label class="font-bold uppercase">{{ $car->chassis }}</label>
            </div>

            <div class="col-span-4 pl-3 border-b border-l border-r border-indigo-600">
                <label class="font-bold text-blue-600">Marca: </label>
                <label class="font-bold capitalize">{{ $car->brand }}</label>
            </div>

            <div class="col-span-4 pl-3 border-b border-r border-indigo-600">
                <label class="font-bold text-blue-600">Modelo: </label>
                <label class="font-bold capitalize">{{ $car->model }}</label>
            </div>
            <div class="col-span-4 pl-3 border-b border-r border-indigo-600">
                <label class="font-bold text-blue-600">Año: </label>
                <label class="font-bold uppercase">{{ $car->year }}</label>
            </div>

            <div class="col-span-4 pl-3 border-b border-l border-r border-indigo-600">
                <label class="font-bold text-blue-600">Color: </label>
                <label class="font-bold capitalize">{{ $car->color }}</label>
            </div>

            <div class="col-span-4 pl-3 border-b border-r border-indigo-600">
            </div>
            <div class="col-span-4 pl-3 border-b border-r border-indigo-600">
                <label class="font-bold text-blue-600">KM: </label>

                <input class="w-full h-4 font-bold sm:w-80" type="number" wire:model='km'>
            </div>

        </div>

        {{-- Productos --}}
        @if(count($products) )
        <div class="grid grid-cols-12 mt-3">
            <div class="col-span-12 text-center border border-indigo-600">
                <label class="font-bold text-blue-600">
                    PRODUCTOS AGREGADOS
                </label>
            </div>

            <div class="col-span-1 pl-3 text-center border-b border-l border-r border-indigo-600">
                <label class="font-bold text-blue-600">CANT</label>
            </div>

            <div class="col-span-7 pl-3 border-b border-r border-indigo-600">
                <label class="font-bold text-blue-600">DESCRIPCIÓN</label>
            </div>
            <div class="col-span-2 pl-3 text-center border-b border-r border-indigo-600">
                <label class="font-bold text-blue-600">P. UNIT</label>
            </div>

            <div class="col-span-2 pl-3 text-center border-b border-r border-indigo-600">
                <label class="font-bold text-blue-600">TOTAL</label>
            </div>

            @foreach ($products as $product )
            <div class="col-span-1 pl-3 text-center border-b border-l border-r border-indigo-600">
                <label class="font-bold uppercase">{{ $product->amount_product_sale }}</label>
            </div>

            <div class="col-span-7 pl-3 border-b border-r border-indigo-600">
                <label class="font-bold capitalize">{{ $product->description_product }}</label>
            </div>
            <div class="col-span-2 pl-3 text-center border-b border-r border-indigo-600">
                <label class="font-bold uppercase">S/.{{ number_format($product->price_product_sale,2) }}</label>
            </div>

            <div class="col-span-2 pl-3 text-center border-b border-r border-indigo-600">
                <label class="font-bold capitalize">S/.{{ number_format($product->amount_product_sale *
                    $product->price_product_sale,2)
                    }}</label>

                <div class="hidden">
                    {{ $total_products += ($product->price_product_sale * $product->amount_product_sale) }}
                </div>
            </div>
            @endforeach
            <div class="col-span-10 pr-3 text-right border-b border-l border-r border-indigo-600">
                <label class="font-bold text-indigo-600 capitalize">TOTAL PRODUCTOS: </label>
            </div>
            <div class="col-span-2 pl-3 text-center border-b border-r border-indigo-600">
                <label class="font-bold capitalize">S/.{{ number_format(
                    $total_products,2)
                    }}</label>
            </div>
        </div>
        @endif

        {{-- Servicios --}}
        @if(count($services))
        <div class="grid grid-cols-12 mt-3">
            <div class="col-span-12 text-center border border-indigo-600">
                <label class="font-bold text-blue-600">
                    SERVICIOS PRESTADOS
                </label>
            </div>

            <div class="col-span-10 pl-3 border-b border-l border-r border-indigo-600">
                <label class="font-bold text-blue-600">
                    DESCRIPCIÓN
                </label>
            </div>

            <div class="col-span-2 pl-3 text-center border-b border-r border-indigo-600">
                <label class="font-bold text-blue-600">PRECIO</label>
            </div>

            @foreach ($services as $service)
            <div class="col-span-10 pl-3 border-b border-l border-r border-indigo-600">
                <label class="font-bold capitalize">
                    {{ $service->description_service }}
                </label>
            </div>

            <div class="col-span-2 pl-3 text-center border-b border-r border-indigo-600">
                <label class="font-bold ">
                    S/.{{ number_format( $service->price_sale_service,
                    2) }}
                </label>
                <div class="hidden">
                    {{ $total_services += $service->price_sale_service }}
                </div>
            </div>
            @endforeach

            <div class="col-span-10 pr-3 text-right border-b border-l border-r border-indigo-600">
                <label class="font-bold text-indigo-600 ">
                    TOTAL SERVICIOS:
                </label>
            </div>

            <div class="col-span-2 pl-3 text-center border-b border-r border-indigo-600">
                <label class="font-bold ">
                    S/.{{ number_format( $total_services,
                    2) }}
                </label>
            </div>
        </div>
        @endif

        {{-- Adelantos --}}
        @if(count($advances))
        <div class="grid grid-cols-12 mt-3">
            <div class="col-span-12 text-center border border-indigo-600">
                <label class="font-bold text-blue-600">
                    ADELANTOS
                </label>
            </div>

            <div class="col-span-4 pl-3 text-center border-b border-l border-r border-indigo-600">
                <label class="font-bold text-blue-600">
                    M. PAGO
                </label>
            </div>

            <div class="col-span-4 pl-3 text-center border-b border-r border-indigo-600">
                <label class="font-bold text-blue-600">
                    FECHA - HORA
                </label>
            </div>

            <div class="col-span-4 pl-3 text-center border-b border-r border-indigo-600">
                <label class="font-bold text-blue-600">
                    MONTO
                </label>
            </div>

            @foreach ($advances as $advance)
            <div class="col-span-4 pl-3 text-center border-b border-l border-r border-indigo-600">
                <label class="font-bold capitalize">
                    {{ $advance->BankAccount->name }}
                </label>
            </div>
            <div class="col-span-4 pl-3 text-center border-b border-l border-r border-indigo-600">
                <label class="font-bold capitalize">
                    {{ $advance->created_at }}
                </label>
            </div>

            <div class="col-span-4 pl-3 text-center border-b border-r border-indigo-600">
                <label class="font-bold ">
                    S/.{{ number_format( $advance->total_advance,
                    2) }}
                </label>
                <div class="hidden">
                    {{ $total_advances += $advance->total_advance }}
                </div>
            </div>
            @endforeach

            <div class="col-span-8 pr-3 text-right border-b border-l border-r border-indigo-600">
                <label class="font-bold text-indigo-600 ">
                    TOTAL SERVICIOS:
                </label>
            </div>

            <div class="col-span-4 pl-3 text-center border-b border-r border-indigo-600">
                <label class="font-bold ">
                    S/.{{ number_format( $total_advances,
                    2) }}
                </label>
            </div>
        </div>
        @endif
        {{-- Sumar --}}
        <div class="hidden">
            {{ $total_pay = ($total_products + $total_services) - ($total_advances + $total_discount_sale ) }}
        </div>
        {{-- Total a Pagar --}}
        @if($total_sale != 0 || $total_discount_sale != 0)
        <div class="grid grid-cols-10 mt-3">
            <div class="col-span-2 text-center border-t border-l border-indigo-600">
                <label class="font-bold text-blue-600">
                    TOTAL PRODUCTOS
                </label>
            </div>
            <div class="col-span-2 text-center border-t border-l border-indigo-600">
                <label class="font-bold text-blue-600">
                    TOTAL SERVICIOS
                </label>
            </div>
            <div class="col-span-2 text-center border-t border-l border-indigo-600">
                <label class="font-bold text-blue-600">
                    TOTAL ADELANTOS
                </label>
            </div>
            <div class="col-span-2 text-center border-t border-l border-indigo-600">
                <label class="font-bold text-blue-600">
                    TOTAL DESCUENTO
                </label>
            </div>
            <div class="col-span-2 text-center border-t border-l border-r border-indigo-600">
                <label class="font-bold text-blue-600">
                    TOTAL A PAGAR
                </label>
            </div>
            <div class="col-span-2 text-center border-t border-b border-l border-indigo-600">
                <label class="font-bold ">
                    S/.{{ number_format(
                    $total_products,2)
                    }}
                </label>
            </div>
            <div class="col-span-2 text-center border-t border-b border-l border-indigo-600">
                <label class="font-bold">
                    S/.{{ number_format(
                    $total_services,2)
                    }}
                </label>
            </div>
            <div class="col-span-2 text-center border-t border-b border-l border-indigo-600">
                <label class="font-bold ">
                    S/.{{ number_format(
                    $total_advances,2)
                    }}
                </label>
            </div>
            <div class="col-span-2 text-center border-t border-b border-l border-indigo-600">
                <label class="font-bold text-red-600 ">
                    - S/.{{ number_format(
                    $total_discount_sale,2)
                    }}
                </label>
            </div>
            <div class="col-span-2 text-center border-t border-b border-l border-r border-indigo-600">
                <label class="font-bold text-green-800">
                    S/.{{ number_format(
                    $total_pay,2)
                    }}
                </label>
            </div>
        </div>
        @endif

        {{-- Observaciones --}}

        <div class="grid grid-cols-12 mt-3">
            <div class="col-span-12 p-2 border border-indigo-600">
                <label class="firts">Observaciones: </label>
                <textarea wire:model="observation_sale" class="w-full" cols="10" rows="2" maxlength="100"></textarea>

            </div>
        </div>

    </div>


    {{-- Productos --}}
    <input type="checkbox" id="product" class="modal-toggle" />
    <div class="modal">
        <div class="w-11/12 max-w-5xl modal-box">
            <label for="product" class="absolute btn btn-sm btn-circle right-2 top-2">✕</label>
            @livewire('sale.product-sale', ['sale'=>$sale])
        </div>
    </div>
    {{-- Servicios --}}
    <input type="checkbox" id="service" class="modal-toggle" />
    <div class="modal">
        <div class="w-11/12 max-w-5xl modal-box">
            <label for="service" class="absolute btn btn-sm btn-circle right-2 top-2">✕</label>
            @livewire('sale.service-sale', ['sale'=>$sale])
        </div>
    </div>
    {{-- Adelanto --}}
    <input type="checkbox" id="advance" class="modal-toggle" />
    <div class="modal">
        <div class="w-11/12 max-w-5xl modal-box">
            <label for="advance" class="absolute btn btn-sm btn-circle right-2 top-2">✕</label>
            @livewire('sale.advance-sale', ['sale'=>$sale->id])
        </div>
    </div>
    {{-- Informes --}}
    <input type="checkbox" id="report" class="modal-toggle" />
    <div class="modal">
        <div class="w-11/12 max-w-5xl modal-box">
            <label for="report" class="absolute btn btn-sm btn-circle right-2 top-2">✕</label>
            @livewire('sale.report-sale', ['sale'=>$sale])
        </div>
    </div>

</div>
