<div>
    <div align="center">
        <div class="inline-flex rounded-md shadow-sm" role="group">
            <button type="button" wire:click="$set('title','ORDENES')"
                class="inline-flex items-center px-4 py-2 text-sm font-medium text-gray-900 bg-white border border-gray-200 rounded-l-lg hover:bg-gray-100 hover:text-blue-700 focus:z-10 focus:ring-2 focus:ring-blue-700 focus:text-blue-700 dark:bg-gray-700 dark:border-gray-600 dark:text-white dark:hover:text-white dark:hover:bg-gray-600 dark:focus:ring-blue-500 dark:focus:text-white">
                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"
                    xmlns="http://www.w3.org/2000/svg">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                        d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-3 7h3m-3 4h3m-6-4h.01M9 16h.01">
                    </path>
                </svg>
                Ordenes
            </button>
            <button type="button" wire:click="$set('title','REPORTES')"
                class="inline-flex items-center px-4 py-2 text-sm font-medium text-gray-900 bg-white border border-gray-200 rounded-r-md hover:bg-gray-100 hover:text-blue-700 focus:z-10 focus:ring-2 focus:ring-blue-700 focus:text-blue-700 dark:bg-gray-700 dark:border-gray-600 dark:text-white dark:hover:text-white dark:hover:bg-gray-600 dark:focus:ring-blue-500 dark:focus:text-white">
                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"
                    xmlns="http://www.w3.org/2000/svg">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                        d="M9 17v-2m3 2v-4m3 4v-6m2 10H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z">
                    </path>
                </svg>
                Reportes
            </button>
        </div>
    </div>
    <div class="hidden sm:block" aria-hidden="true">
        <div class="mt-5" align="center">
            <label class="text-2xl font-bold text-indigo-600">{{ $title }}</label>
        </div>
        <div class="py-5">
            <div class="border-t border-gray-200"></div>
        </div>
    </div>
    @if($title == 'REPORTES')
    <div class="relative overflow-x-auto shadow-md sm:rounded-lg">
        <table class="w-full text-sm text-left text-gray-500 dark:text-gray-400">
            <thead class="text-xs text-gray-700 uppercase bg-gray-50 dark:bg-gray-700 dark:text-gray-400">
                <tr>
                    <th scope="col" class="px-6 py-3">
                        Tipo
                    </th>
                    <th scope="col" class="px-6 py-3">
                        Comentario
                    </th>
                    <th scope="col" class="px-6 py-3">
                        Mecánico
                    </th>
                </tr>
            </thead>
            <tbody>
                @foreach ($reports as $comment )
                <tr
                    class="border-b dark:bg-gray-800 dark:border-gray-700 odd:bg-white even:bg-gray-50 odd:dark:bg-gray-800 even:dark:bg-gray-700">
                    <td class="px-6 py-4">
                        @switch( $comment->type_detail)
                        @case(0)
                        Servicio
                        @break
                        @case(1)
                        Producto
                        @break
                        @case(2)
                        Comentario
                        @break

                        @default

                        @endswitch
                    </td>
                    <th scope="row"
                        class="px-6 py-4 font-medium text-gray-900 uppercase dark:text-white whitespace-nowrap">
                        {{ $comment->detail }}
                    </th>

                    <th scope="row"
                        class="px-6 py-4 font-medium text-gray-900 uppercase dark:text-white whitespace-nowrap">
                        {{ $comment->User->name }}
                    </th>

                </tr>
                @endforeach
            </tbody>
        </table>
        {{ $reports->links() }}
    </div>
    @else
    <div class="relative overflow-x-auto shadow-md sm:rounded-lg">
        <table class="w-full text-sm text-left text-gray-500 dark:text-gray-400">
            <thead class="text-xs text-gray-700 uppercase bg-gray-50 dark:bg-gray-700 dark:text-gray-400">
                <tr>
                    <th scope="col" class="px-6 py-3">
                        DESCRIPCIÓN
                    </th>
                    <th scope="col" class="px-6 py-3">
                        TIPO
                    </th>
                    <th scope="col" class="px-6 py-3">
                        ESTADO
                    </th>
                </tr>
            </thead>
            <tbody>
                @foreach ($orders as $order )
                <tr
                    class="border-b dark:bg-gray-800 dark:border-gray-700 odd:bg-white even:bg-gray-50 odd:dark:bg-gray-800 even:dark:bg-gray-700">
                    <td class="px-6 py-4">
                        {{ $order->order_description }}
                    </td>
                    <th scope="row" class="px-6 py-4 font-medium text-gray-900 dark:text-white whitespace-nowrap">
                        {{ $order->order_type }}
                    </th>
                    <th scope="row" class="px-6 py-4 font-medium text-gray-900 dark:text-white whitespace-nowrap">

                        @if($order->order_status == '0')
                        <button type="button"
                            class="inline-block px-6 py-2.5 bg-red-600 text-white font-medium text-xs leading-tight uppercase rounded shadow-md hover:bg-red-700 hover:shadow-lg focus:bg-red-700 focus:shadow-lg focus:outline-none focus:ring-0 active:bg-red-800 active:shadow-lg transition duration-150 ease-in-out">
                            En Progreso</button>

                        @else
                        <button type="button"
                            class="inline-block px-6 py-2.5 bg-green-500 text-white font-medium text-xs leading-tight uppercase rounded shadow-md hover:bg-green-600 hover:shadow-lg focus:bg-green-600 focus:shadow-lg focus:outline-none focus:ring-0 active:bg-green-700 active:shadow-lg transition duration-150 ease-in-out">
                            Finalizado</button>

                        @endif
                    </th>

                </tr>
                @endforeach
            </tbody>
        </table>
        {{ $orders->links() }}
    </div>
    @endif

</div>
