<div>
    {{-- Tabla --}}
    <div class="relative overflow-x-auto shadow-md sm:rounded-lg">
        <div class="flex p-4 text-right">

            <div class="w-full ">
                <select wire:model='status'
                    class="block w-full px-3 py-2 mt-1 font-medium text-indigo-700 uppercase bg-white border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm">
                    @foreach ($sale_statuses as $id=> $status )
                    <option value={{ $id }} class="font-bold text-indigo-700 ">{{ $status }}</option>
                    @endforeach
                </select>

            </div>
            <div class="relative w-full ">
                <div class="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none">
                    <svg class="w-5 h-5 mb-2 text-gray-500 dark:text-gray-400" fill="currentColor" viewBox="0 0 20 20"
                        xmlns="http://www.w3.org/2000/svg">
                        <path fill-rule="evenodd"
                            d="M8 4a4 4 0 100 8 4 4 0 000-8zM2 8a6 6 0 1110.89 3.476l4.817 4.817a1 1 0 01-1.414 1.414l-4.816-4.816A6 6 0 012 8z"
                            clip-rule="evenodd"></path>
                    </svg>
                </div>
                <input type="text" wire:model='search'
                    class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full pl-10 p-2.5  dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500"
                    placeholder="Buscar por la placa de los Vehículos" autocomplete="off">

            </div>
            <label for="remember" type="button"
                class="ml-4 cursor-pointer text-white bg-green-700 hover:bg-green-800 focus:ring-4 focus:ring-green-300 font-medium rounded-lg text-sm px-5 py-2.5 mr-2 mb-2 dark:bg-green-600 dark:hover:bg-green-700 focus:outline-none dark:focus:ring-green-800">
                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"
                    xmlns="http://www.w3.org/2000/svg">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                        d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z">
                    </path>
                </svg>
            </label>
            <label for="notification" type="button"
                class="ml-4 cursor-pointer text-white bg-rose-700 hover:bg-rose-800 focus:ring-4 focus:ring-rose-300 font-medium rounded-lg text-sm px-5 py-2.5 mr-2 mb-2 dark:bg-rose-600 dark:hover:bg-rose-700 focus:outline-none dark:focus:ring-rose-800">
                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"
                    xmlns="http://www.w3.org/2000/svg">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                        d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9">
                    </path>
                </svg>
            </label>
            <label for="create" type="button"
                class="ml-4 cursor-pointer text-white bg-indigo-700 hover:bg-indigo-800 focus:ring-4 focus:ring-indigo-300 font-medium rounded-lg text-sm px-5 py-2.5 mr-2 mb-2 dark:bg-indigo-600 dark:hover:bg-indigo-700 focus:outline-none dark:focus:ring-indigo-800">
                <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-circle-plus" width="24"
                    height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none"
                    stroke-linecap="round" stroke-linejoin="round">
                    <desc>Download more icon variants from https://tabler-icons.io/i/circle-plus</desc>
                    <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                    <circle cx="12" cy="12" r="9"></circle>
                    <line x1="9" y1="12" x2="15" y2="12"></line>
                    <line x1="12" y1="9" x2="12" y2="15"></line>
                </svg>
            </label>
        </div>

        <table class="w-full text-sm text-left text-gray-500 dark:text-gray-400">
            <thead class="text-xs text-gray-700 uppercase bg-gray-50 dark:bg-gray-700 dark:text-gray-400">
                <tr>
                    <th scope="col" class="px-6 py-3">
                        N°
                    </th>
                    <th scope="col" class="px-6 py-3">
                        PLACA
                    </th>
                    <th scope="col" class="px-6 py-3">
                        MODELO
                    </th>
                    <th scope="col" class="px-6 py-3">
                        M. Pago
                    </th>
                    <th scope="col" class="px-6 py-3">
                        PROPIETARIO
                    </th>
                    <th scope="col" class="px-6 py-3">
                        CONDUCTOR
                    </th>
                    <th scope="col" class="px-6 py-3">
                        ESTADO
                    </th>
                    <th scope="col" class="px-6 py-3">
                        <span class="sr-only">Edit</span>
                    </th>
                </tr>
            </thead>
            <tbody>
                @foreach ($sales as $sale )
                <tr
                    class="bg-white border-b dark:bg-gray-800 dark:border-gray-700 hover:bg-gray-50 dark:hover:bg-gray-600">
                    <th scope="row" class="px-6 py-4 font-medium text-gray-900 dark:text-white whitespace-nowrap">
                        {{ $sale->id }}
                    </th>
                    <th scope="row"
                        class="px-6 py-4 font-medium text-gray-900 uppercase dark:text-white whitespace-nowrap">
                        {{ $sale->Car->plate }}
                    </th>
                    <td class="px-6 py-4 capitalize">
                        {{ $sale->Car->model }}
                    </td>
                    <td class="px-6 py-4 capitalize">
                        {{ $sale->BankAccount->name }}
                    </td>
                    <td class="px-6 py-4 capitalize">
                        {{ $sale->Car->Client->dni }} || {{ $sale->Car->Client->names }}
                    </td>
                    <td class="px-6 py-4 capitalize">
                        {{ $sale->Client->names }}
                    </td>
                    <td class="px-6 py-4 uppercase">
                        <span class="px-2 py-1 font-semibold leading-tight text-indigo-700 bg-indigo-100 rounded-sm">
                            {{ $sale->Condition->description }}
                        </span>
                    </td>
                    <td class="px-6 py-4 text-right">
                        <a href="{{ route('sale.show', $sale) }}" type="button"
                            class="text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:ring-blue-300 font-medium rounded-lg text-sm px-5 py-2.5 mr-2 mb-2 dark:bg-blue-600 dark:hover:bg-blue-700 focus:outline-none dark:focus:ring-blue-800">
                            <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-eye-check"
                                width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor"
                                fill="none" stroke-linecap="round" stroke-linejoin="round">
                                <desc>Download more icon variants from https://tabler-icons.io/i/eye-check</desc>
                                <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                <circle cx="12" cy="12" r="2"></circle>
                                <path
                                    d="M12 19c-4 0 -7.333 -2.333 -10 -7c2.667 -4.667 6 -7 10 -7s7.333 2.333 10 7c-.42 .736 -.858 1.414 -1.311 2.033">
                                </path>
                                <path d="M15 19l2 2l4 -4"></path>
                            </svg></a>

                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
        {{ $sales->links() }}
    </div>



    {{-- Modal Create --}}
    <input type="checkbox" id="create" class="modal-toggle" />
    <div class="modal">
        <div class="w-11/12 max-w-5xl modal-box">
            <label for="create" class="absolute btn btn-sm btn-circle right-2 top-2">✕</label>
            @livewire('sale.create-sale')
        </div>
    </div>


    {{-- Modal Remember --}}
    <input type="checkbox" id="remember" class="modal-toggle" />
    <div class="modal">
        <div class="w-11/12 max-w-5xl modal-box">
            <label for="remember" class="absolute btn btn-sm btn-circle right-2 top-2">✕</label>
            @livewire('debt.index-debt')
        </div>
    </div>

    {{-- Modal notification --}}
    <input type="checkbox" id="notification" class="modal-toggle" />
    <div class="modal">
        <div class="w-11/12 max-w-5xl modal-box">
            <label for="notification" class="absolute btn btn-sm btn-circle right-2 top-2">✕</label>
            @livewire('notification.index-notification')
        </div>
    </div>
</div>