<div>
    <div class="hidden sm:block" aria-hidden="true">
        <div class="py-5">
            <div class="border-t border-gray-200"></div>
        </div>
    </div>
    {{-- Agregar --}}
    <div class="relative w-full overflow-x-auto shadow-md sm:rounded-lg">
        <div class="flex p-4">
            <div class="relative">
                <div class="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"
                        xmlns="http://www.w3.org/2000/svg">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2zm7-5a2 2 0 11-4 0 2 2 0 014 0z">
                        </path>
                    </svg>
                </div>
                <input wire:model="total_advance" type="number"
                    class=" w-32 sm:w-80 bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block  pl-10 p-2.5  dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500"
                    placeholder="S/. 0.00" autocomplete="off">

                @error('total_advance')
                <span class="error">*{{ $message }}</span>
                @enderror
            </div>
            <select wire:model='bank_account_id'
                class="ml-4 w-56 sm:w-full capitalize bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-50  p-2.5  dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
                <option disabled value=null>Selecciona una Cuenta</option>
                @foreach ($banks as $id => $type)
                <option value={{ $id }} class="font-bold text-green-700">{{ $type }}</option>
                @endforeach
            </select>
            @error('bank_account_id')
            <span class="error">*{{ $message }}</span>
            @enderror
            <button wire:click='add'
                class="ml-4 cursor-pointer text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:ring-blue-300 font-medium rounded-lg text-sm px-5 py-2.5  dark:bg-blue-600 dark:hover:bg-blue-700 focus:outline-none dark:focus:ring-blue-800">
                <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-layout-grid-add" width="24"
                    height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none"
                    stroke-linecap="round" stroke-linejoin="round">
                    <desc>Download more icon variants from https://tabler-icons.io/i/layout-grid-add</desc>
                    <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                    <rect x="4" y="4" width="6" height="6" rx="1"></rect>
                    <rect x="14" y="4" width="6" height="6" rx="1"></rect>
                    <rect x="4" y="14" width="6" height="6" rx="1"></rect>
                    <path d="M14 17h6m-3 -3v6"></path>
                </svg>
            </button>

        </div>


    </div>


    <table class="w-full text-sm text-left text-gray-500 dark:text-gray-400">
        <thead class="text-xs text-gray-700 uppercase bg-gray-50 dark:bg-gray-700 dark:text-gray-400">
            <tr>
                <th scope="col" class="px-6 py-3">
                    Descripción
                </th>
                <th scope="col" class="px-6 py-3">
                    Precio Unitario
                </th>
                <th scope="col" class="px-6 py-3">
                    fecha
                </th>
            </tr>
        </thead>
        <tbody>
            @foreach ( $advances as $advance )
            <tr class="bg-white border-b dark:bg-gray-800 dark:border-gray-700 hover:bg-gray-50 dark:hover:bg-gray-600">
                <th scope="row"
                    class="px-4 py-1 font-medium text-gray-900 capitalize dark:text-white whitespace-nowrap">
                    S/.{{ number_format( $advance->total_advance ,2)}}
                </th>
                <td class="px-4 py-1 capitalize">
                    {{ $advance->BankAccount->name }}
                </td>
                <td class="px-4 py-1 capitalize">
                    {{ $advance->created_at->format('d-m-Y') }}
                    {{ now()->format('d-m-Y') }}

                </td>
                <td class="px-4 py-1 text-right">
                    @if(now()->format('d-m-Y') == $advance->created_at->format('d-m-Y') )
                    <button type="button" wire:click="quit({{ $advance->id }})"
                        class="focus:outline-none text-white bg-red-700 hover:bg-red-800 focus:ring-4 focus:ring-red-300 font-medium rounded-lg text-sm px-3 py-1.5  dark:bg-red-600 dark:hover:bg-red-700 dark:focus:ring-red-900">
                        <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-circle-minus"
                            width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor"
                            fill="none" stroke-linecap="round" stroke-linejoin="round">
                            <desc>Download more icon variants from https://tabler-icons.io/i/circle-minus</desc>
                            <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                            <circle cx="12" cy="12" r="9"></circle>
                            <line x1="9" y1="12" x2="15" y2="12"></line>
                        </svg>
                    </button>
                    @endif


                </td>
            </tr>
            @endforeach
        </tbody>
    </table>
    {{ $advances->links() }}
</div>
