<div>

    <label for="countries" class="block mb-2 text-sm font-medium text-gray-900 dark:text-gray-400">
        Cuentas Bancarias
    </label>
    <select wire:model='bank_selected_id'
        class="mb-5 capitalize font-bold w-60 bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block  p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
        @foreach ($banks as $bank )
        <option value={{ $bank->id }}>{{ $bank->name }}</option>
        @endforeach
    </select>



    {{-- Ventas --}}
    <label for="countries" class="block mb-2 text-lg font-bold text-gray-900 dark:text-gray-400">
        VENTAS PAGADAS
    </label>
    <div class="relative overflow-auto max-h-96 shadow-md sm:rounded-lg">
        <table class="w-full text-sm text-left text-gray-500 table-fixed dark:text-gray-400">
            <thead class="text-xs text-gray-700 uppercase dark:text-gray-400">
                <tr>
                    <th scope="col" class="px-6 py-3 bg-gray-50 dark:bg-gray-800">
                        N° VENTA
                    </th>
                    <th scope="col" class="px-6 py-3">
                        TOTAL
                    </th>
                    <th scope="col" class="px-6 py-3 bg-gray-50 dark:bg-gray-800">
                        FECHA DE PAGO
                    </th>
                </tr>
            </thead>
            <tbody>
                @foreach ($sales as $sale)
                <tr class="border-b border-gray-200 dark:border-gray-700">
                    <th scope="row"
                        class="px-6 py-4 font-medium text-gray-900 whitespace-nowrap bg-gray-50 dark:text-white dark:bg-gray-800">
                        {{ $sale->id }}
                    </th>
                    <td class="px-6 py-4 font-bold text-green-700">
                        S/. {{ number_format( $sale->total_pay,2)}}
                    </td>
                    <td class="px-6 py-4 bg-gray-50 dark:bg-gray-800">
                        {{ $sale->updated_at }}
                    </td>
                    <div class="hidden">
                        {{ $total_sales += $sale->total_pay }}
                    </div>
                </tr>
                @endforeach
                <tr class="border-b border-gray-200 dark:border-gray-700">
                    <th scope="row"
                        class="px-6 py-4 font-medium text-gray-900 whitespace-nowrap bg-gray-50 dark:text-white dark:bg-gray-800">
                        TOTAL DE VENTAS
                    </th>
                    <td class="px-6 py-4 font-bold text-green-700">
                        S/. {{ number_format( $total_sales,2)}}
                    </td>
                    <td class="px-6 py-4 bg-gray-50 dark:bg-gray-800">

                    </td>
                </tr>
            </tbody>
        </table>
    </div>

    {{-- Adelanto --}}
    <label for="countries" class="block mt-2 mb-2 text-lg font-bold text-gray-900 dark:text-gray-400">
        ADELANTOS
    </label>
    <div class="relative overflow-auto max-h-96 shadow-md sm:rounded-lg">
        <table class="w-full text-sm text-left text-gray-500 table-fixed dark:text-gray-400">
            <thead class="text-xs text-gray-700 uppercase dark:text-gray-400">
                <tr>
                    <th scope="col" class="px-6 py-3 bg-gray-50 dark:bg-gray-800">
                        N° VENTA
                    </th>
                    <th scope="col" class="px-6 py-3">
                        TOTAL
                    </th>
                    <th scope="col" class="px-6 py-3 bg-gray-50 dark:bg-gray-800">
                        FECHA DE ADELANTO
                    </th>
                </tr>
            </thead>
            <tbody>
                @foreach ($advances as $advance)
                <tr class="border-b border-gray-200 dark:border-gray-700">
                    <th scope="row"
                        class="px-6 py-4 font-medium text-gray-900 whitespace-nowrap bg-gray-50 dark:text-white dark:bg-gray-800">
                        {{ $advance->id }}
                    </th>
                    <td class="px-6 py-4 font-bold text-green-700">
                        S/. {{ number_format( $advance->total_advance,2)}}
                    </td>
                    <td class="px-6 py-4 bg-gray-50 dark:bg-gray-800">
                        {{ $advance->updated_at }}
                    </td>
                    <div class="hidden">
                        {{ $total_advances += $advance->total_advance }}
                    </div>
                </tr>
                @endforeach
                <tr class="border-b border-gray-200 dark:border-gray-700">
                    <th scope="row"
                        class="px-6 py-4 font-medium text-gray-900 whitespace-nowrap bg-gray-50 dark:text-white dark:bg-gray-800">
                        TOTAL DE ADELANTOS
                    </th>
                    <td class="px-6 py-4 font-bold text-green-700">
                        S/. {{ number_format( $total_advances,2)}}
                    </td>
                    <td class="px-6 py-4 bg-gray-50 dark:bg-gray-800">

                    </td>
                </tr>
            </tbody>
        </table>
    </div>

    {{-- MOVIMIENTOS --}}
    <label for="countries" class="block mt-2 mb-2 text-lg font-bold text-gray-900 dark:text-gray-400">
        MOVIMIENTOS
    </label>
    <div class="relative overflow-auto max-h-96  shadow-md sm:rounded-lg">
        <table class="w-full text-sm text-left text-gray-500 table-fixed dark:text-gray-400">
            <thead class="text-xs text-gray-700 uppercase dark:text-gray-400">
                <tr>
                    <th scope="col" class="px-6 py-3 bg-gray-50 dark:bg-gray-800">
                        CONCEPTO
                    </th>
                    <th scope="col" class="px-6 py-3">
                        PERSONA
                    </th>
                    <th scope="col" class="px-6 py-3 bg-gray-50 dark:bg-gray-800">
                        TOTAL
                    </th>
                    <th scope="col" class="px-6 py-3">
                        FECHA DE MOVIMIENTO
                    </th>
                </tr>
            </thead>
            <tbody>
                @foreach ($movements as $movement)
                <tr class="border-b border-gray-200 dark:border-gray-700">
                    <th scope="row"
                        class="px-6 py-4 font-medium text-gray-900 capitalize whitespace-nowrap bg-gray-50 dark:text-white dark:bg-gray-800">
                        {{ $movement->id }} {{ $movement->concept }}
                    </th>
                    <td class="px-6 py-4 capitalize ">
                        {{ $movement->person}}
                    </td>
                    <td class="px-6 py-4 font-bold text-green-700 bg-gray-50 dark:bg-gray-800">
                        S/. {{ number_format( $movement->total_movement,2)}}
                    </td>
                    <td class="px-6 py-4 ">
                        {{ $movement->updated_at }}
                    </td>
                    <div class="hidden">
                        {{ $total_movements += $movement->total_movement }}
                    </div>
                </tr>
                @endforeach
                <tr class="border-b border-gray-200 dark:border-gray-700">
                    <th scope="row"
                        class="px-6 py-4 font-medium text-gray-900 whitespace-nowrap bg-gray-50 dark:text-white dark:bg-gray-800">

                    </th>
                    <td class="px-6 py-4 ">
                        TOTAL DE ADELANTOS
                    </td>
                    <td class="px-6 py-4 font-bold text-green-700 bg-gray-50 dark:bg-gray-800">
                        S/. {{ number_format( $total_movements,2)}}
                    </td>
                    <td class="px-6 py-4 ">

                    </td>
                </tr>
            </tbody>
        </table>
    </div>

    {{-- TOTAL --}}
    <label for="countries" class="block mt-2 mb-2 text-lg font-bold text-gray-900 dark:text-gray-400">
        TOTAL
    </label>
    <div class="relative overflow-x-auto shadow-md sm:rounded-lg">
        <table class="w-full text-sm text-left text-gray-500 table-fixed dark:text-gray-400">
            <thead class="text-xs text-gray-700 uppercase dark:text-gray-400">
                <tr>
                    <th scope="col" class="px-6 py-3 bg-gray-50 dark:bg-gray-800">
                        VENTAS
                    </th>
                    <th scope="col" class="px-6 py-3">
                        ADELANTOS
                    </th>
                    <th scope="col" class="px-6 py-3 bg-gray-50 dark:bg-gray-800">
                        MOVIMIENTOS
                    </th>
                    <th scope="col" class="px-6 py-3">
                        TOTAL
                    </th>
                </tr>
            </thead>
            <tbody>

                <tr class="border-b border-gray-200 dark:border-gray-700">
                    <th scope="row"
                        class="px-6 py-4 font-bold text-green-700 whitespace-nowrap bg-gray-50 dark:text-white dark:bg-gray-800">
                        S/. {{ number_format($total_sales,2) }}
                    </th>
                    <td class="px-6 py-4 font-bold text-green-700 ">
                        S/. {{ number_format($total_advances,2)}}
                    </td>
                    <td class="px-6 py-4 font-bold text-green-700 bg-gray-50 dark:bg-gray-800">
                        S/. {{ number_format( $total_movements,2)}}
                    </td>
                    <td class="px-6 py-4 font-bold text-green-700">
                        S/. {{ number_format($total_sales + $total_advances +$total_movements,2) }}
                    </td>
                </tr>
            </tbody>
        </table>
    </div>

</div>