<div>
    {{-- Buscador --}}
    <div class="flex p-4">
        <div class="relative w-full ">
            <div class="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none">
                <svg class="w-5 h-5 mb-2 text-gray-500 dark:text-gray-400" fill="currentColor" viewBox="0 0 20 20"
                    xmlns="http://www.w3.org/2000/svg">
                    <path fill-rule="evenodd"
                        d="M8 4a4 4 0 100 8 4 4 0 000-8zM2 8a6 6 0 1110.89 3.476l4.817 4.817a1 1 0 01-1.414 1.414l-4.816-4.816A6 6 0 012 8z"
                        clip-rule="evenodd"></path>
                </svg>
            </div>
            <input type="text" wire:model='search'
                class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full pl-10 p-2.5  dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500"
                placeholder="Buscar por la descripción de los productos" autocomplete="off">
        </div>
        <label for="create" type="button"
            class="ml-2 cursor-pointer text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:ring-blue-300   rounded-lg text-sm px-5 py-2.5 mr-2 mb-2 dark:bg-blue-600 dark:hover:bg-blue-700 focus:outline-none dark:focus:ring-blue-800">
            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"
                xmlns="http://www.w3.org/2000/svg">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                    d="M17 14v6m-3-3h6M6 10h2a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v2a2 2 0 002 2zm10 0h2a2 2 0 002-2V6a2 2 0 00-2-2h-2a2 2 0 00-2 2v2a2 2 0 002 2zM6 20h2a2 2 0 002-2v-2a2 2 0 00-2-2H6a2 2 0 00-2 2v2a2 2 0 002 2z">
                </path>
            </svg>
        </label>
    </div>
    {{-- Tabla --}}
    <div class="relative overflow-x-auto shadow-md sm:rounded-lg">

        <table class="w-full text-sm font-bold text-left text-gray-500 dark:text-gray-400">
            <thead class="text-xs text-gray-700 uppercase bg-gray-50 dark:bg-gray-700 dark:text-gray-400">
                <tr>
                    <th scope="col" class="px-6 py-3">
                        DESCRIPCIÓN ÚNICA
                    </th>
                    <th scope="col" class="px-6 py-3">
                        DESCRIPCIÓN BOLETA
                    </th>
                    <th scope="col" class="px-6 py-3 text-center">
                        PRECIO COMPRA
                    </th>
                    <th scope="col" class="px-6 py-3 text-center">
                        PRECIO VENTA
                    </th>
                    <th scope="col" class="px-6 py-3 text-center">
                        ALMACEN
                    </th>
                    <th scope="col" class="px-6 py-3 text-center">
                        ESTADO
                    </th>
                    <th scope="col" class="px-6 py-3">
                        <span class="sr-only">Edit</span>
                    </th>
                </tr>
            </thead>
            <tbody>
                @forelse ($products as $item )
                <tr
                    class="bg-white border-b cursor-pointer dark:bg-gray-800 dark:border-gray-700 hover:bg-gray-50 dark:hover:bg-gray-600">
                    <th scope="row" class="px-6 py-4 text-gray-900 uppercase dark:text-white whitespace-nowrap">
                        {{$item->description_product}}
                    </th>
                    <td class="px-6 py-4 text-center uppercase">
                        {{ $item->description_product_bolet }}
                    </td>
                    <td class="px-6 py-4 text-center">
                        {{ $item->buy_product }}
                    </td>
                    <td class="px-6 py-4 text-center">
                        {{ $item->sell_product }}
                    </td>
                    <td class="px-6 py-4 text-center">
                        {{ $item->stock_product }}
                    </td>
                    <td class="px-6 py-4 text-center">
                        @if($item->status_product)
                        <span class="px-2 py-1 font-semibold leading-tight text-green-700 bg-green-100 rounded-sm">
                            EN SERVICIO
                        </span>
                        @else
                        <span class="px-2 py-1 font-semibold leading-tight text-red-700 bg-red-100 rounded-sm">
                            FUERA DE SERVICIO
                        </span>
                        @endif
                    </td>
                    <td class="flex mt-2">
                        <label wire:click="$set('product', {{ $item }})" for="edit" type="button"
                            class="p-2 mb-2 ml-2 mr-2 text-sm text-white bg-teal-600 rounded-lg cursor-pointer hover:bg-teal-700 focus:ring-4 focus:ring-blue-300 dark:bg-teal-600 dark:hover:bg-teal-700 focus:outline-none dark:focus:ring-teal-800">
                            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"
                                xmlns="http://www.w3.org/2000/svg">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z">
                                </path>
                            </svg>
                        </label>
                        <button wire:click="question({{ $item }})" type="button"
                            class="p-2 mb-2 ml-2 mr-2 text-sm text-white rounded-lg bg-rose-700 hover:bg-rose-800 focus:ring-4 focus:ring-rose-300 dark:bg-rose-600 dark:hover:bg-rose-700 focus:outline-none dark:focus:ring-rose-800">
                            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"
                                xmlns="http://www.w3.org/2000/svg">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M15 12H9m12 0a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                        </button>
                    </td>
                </tr>
                @empty
                <h1 class="p-2 text-lg font-bold text-red-700">No se encontraron resultados</h1>
                @endforelse

            </tbody>
        </table>
        {{ $products->links() }}
    </div>

    {{-- Modal Create --}}
    <input type="checkbox" id="create" class="modal-toggle" />
    <div class="modal">
        <div class="w-11/12 max-w-5xl modal-box">
            <label for="create" class="absolute btn btn-sm btn-circle right-2 top-2">✕</label>
            @livewire('product.create-product')

        </div>
    </div>

    {{-- Modal Edit --}}
    <input type="checkbox" id="edit" class="modal-toggle" />
    <div class="modal">
        <div class="w-11/12 max-w-5xl modal-box">
            <label for="edit" wire:click="$set('product',null)"
                class="absolute btn btn-sm btn-circle right-2 top-2">✕</label>
            {{-- Content Edit --}}
            @if($product)
            @livewire('product.edit-product', ['product'=> $product])
            @else
            @include('components.load')
            @endif
            {{-- End Content --}}
        </div>
    </div>
</div>
