<div>
    <div class="hidden sm:block" aria-hidden="true">
        <div class="py-5">
            <div class="border-t border-gray-200"></div>
        </div>
    </div>

    <div class="mt-10 sm:mt-0">
        <div class="md:grid md:grid-cols-3 md:gap-6">
            <div class="md:col-span-1">
                <div class="px-4 sm:px-0">
                    <h3 class="text-lg leading-6 text-gray-900">Información del Producto</h3>
                    <p class="mt-1 text-sm text-gray-600">
                        La descripción registrada del producto, será usada en la ventas
                    </p>
                </div>
            </div>
            <div class="mt-5 md:mt-0 md:col-span-2">
                <form wire:submit.prevent='save'>
                    <div class="overflow-hidden shadow sm:rounded-md">
                        <div class="px-4 py-5 bg-white sm:p-6">
                            <div class="grid grid-cols-6 gap-6">
                                <div class="col-span-6 sm:col-span-6">
                                    <label for="first-name" class="block text-sm text-gray-700">
                                        Descripción del Producto <span class="error">(ÚNICO)</span>
                                    </label>
                                    <input wire:model='description_product' autocomplete="off" type="text"
                                        name="description_product" id=""
                                        class="block w-full px-3 py-2 mt-1 uppercase bg-white border-2 border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm">
                                    @error('description_product')
                                    <span class="text-red-700">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="col-span-6 sm:col-span-6">
                                    <label for="first-name" class="block text-sm text-gray-700">
                                        Descripción del Producto <span class="error">(BOLETA)</span>
                                    </label>
                                    <input wire:model='description_product_bolet' autocomplete="off" type="text"
                                        name="description_product_bolet" id=""
                                        class="block w-full px-3 py-2 mt-1 uppercase bg-white border-2 border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm">
                                    @error('description_product_bolet')
                                    <span class="text-red-700">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div class="col-span-6 sm:col-span-3">
                                    <label for="first-name" class="block text-sm text-gray-700">
                                        Precio de compra del Producto</label>
                                    <input wire:model='buy_product' autocomplete="off" type="number" step=".01"
                                        class="block w-full px-3 py-2 mt-1 bg-white border-2 border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm">
                                    @error('buy_product')
                                    <span class="text-red-700">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div class="col-span-6 sm:col-span-3">
                                    <label for="first-name" class="block text-sm text-gray-700">
                                        Precio de venta del Producto</label>
                                    <input wire:model='sell_product' autocomplete="off" type="number" step=".01"
                                        class="block w-full px-3 py-2 mt-1 bg-white border-2 border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm">
                                    @error('sell_product')
                                    <span class="text-red-700">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div class="col-span-6 sm:col-span-3">
                                    <label for="" class="block text-sm text-gray-700">
                                        Estado del Producto
                                    </label>
                                    <select wire:model='status_product' id="" name="country" autocomplete="country-name"
                                        class="block w-full px-3 py-2 mt-1 text-indigo-700 bg-white border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm">
                                        <option value='1' class="font-bold text-green-700">En Servicio</option>
                                        <option value='0' class="font-bold text-red-700">Fuera de Servicio</option>
                                    </select>
                                </div>
                                <div class="col-span-6 sm:col-span-3">
                                    <label for="first-name" class="block text-sm text-gray-700">
                                        Cantida en Almacen</label>
                                    <input wire:model='stock_product' autocomplete="off" type="number"
                                        class="block w-full px-3 py-2 mt-1 bg-white border-2 border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm">
                                    @error('stock_product')
                                    <span class="text-red-700">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="px-4 py-3 text-right bg-gray-50 sm:px-6">
                            <button type="submit"
                                class="inline-flex justify-center px-4 py-2 text-sm text-white bg-indigo-600 border border-transparent rounded-md shadow-sm hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                                <svg xmlns="http://www.w3.org/2000/svg"
                                    class="icon icon-tabler icon-tabler-device-floppy" width="24" height="24"
                                    viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none"
                                    stroke-linecap="round" stroke-linejoin="round">
                                    <desc>Download more icon variants from https://tabler-icons.io/i/device-floppy
                                    </desc>
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                    <path d="M6 4h10l4 4v10a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2">
                                    </path>
                                    <circle cx="12" cy="14" r="2"></circle>
                                    <polyline points="14 4 14 8 8 8 8 4"></polyline>
                                </svg>
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="hidden sm:block" aria-hidden="true">
        <div class="py-5">
            <div class="border-t border-gray-200"></div>
        </div>
    </div>

</div>
