<div>

    <div class="accordion" id="accordionExample">
        <div class="bg-white accordion-item">
            <h2 class="mb-0 accordion-header" id="headingTwo">

                <label for="create" type="button"
                    class="cursor-pointer ml-2 mb-2 inline-block px-6 py-2.5 bg-blue-700 text-white font-medium text-xs leading-tight uppercase rounded shadow-md hover:bg-blue-700 hover:shadow-lg focus:bg-blue-700 focus:shadow-lg focus:outline-none focus:ring-0 active:bg-blue-800 active:shadow-lg transition duration-150 ease-in-out">
                    Agregar
                </label>
                <label for="list" type="button"
                    class="cursor-pointer ml-2 mb-2 inline-block px-6 py-2.5 bg-blue-700 text-white font-medium text-xs leading-tight uppercase rounded shadow-md hover:bg-blue-700 hover:shadow-lg focus:bg-blue-700 focus:shadow-lg focus:outline-none focus:ring-0 active:bg-blue-800 active:shadow-lg transition duration-150 ease-in-out">
                    Reportes
                </label>

            </h2>
        </div>
        <div class="bg-white border border-gray-200 accordion-item">
            <h2 class="mb-0 accordion-header" id="headingOne">
                <div class="relative flex items-center w-full px-5 py-4 text-base text-left text-gray-800 transition bg-white border-0 rounded-none accordion-button focus:outline-none"
                    type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne" aria-expanded="true"
                    aria-controls="collapseOne">
                    <label class="text-3xl font-bold text-indigo-700">DATOS</label>
                </div>
            </h2>
            <div id="collapseOne" class="accordion-collapse collapse show" aria-labelledby="headingOne"
                data-bs-parent="#accordionExample">
                <div class="px-5 py-4 text-base accordion-body">
                    <label class="font-bold">Placa: </label> <label class="font-bold text-black uppercase">{{
                        $sale->Car->plate }}</label> <br>
                    <label class="font-bold">Propietario:</label> <label class="font-bold text-black capitalize">{{
                        $sale->Car->Client->names }}</label> <br>
                    <label class="font-bold">Modelo: </label> <label class="font-bold text-black capitalize">{{
                        $sale->Car->model }}</label> <br>
                    <label class="font-bold">Color: </label> <label class="font-bold text-black capitalize">{{
                        $sale->Car->color }}</label>
                </div>
            </div>
        </div>
    </div>

    <div class="mt-5 overflow-y-auto sm:-mx-6">
        <div class="inline-block py-2 break-all align-middle sm:px-6 lg:px-8">
            <div class="border-gray-200 shadow overflow-y-autoborder-b sm:rounded-lg">
                <table class="w-full divide-y divide-gray-200 table-fixed">
                    <thead class="bg-gray-50">
                        <tr>
                            <th
                                class="w-1/2 px-6 py-3 text-xs font-medium tracking-wider text-left text-gray-800 uppercase bg-gray-200">
                                Comentario
                            </th>
                            <th
                                class="w-1/2 px-6 py-3 text-xs font-medium tracking-wider text-left text-gray-800 uppercase bg-gray-200">
                                Tipo
                            </th>
                            <th scope="col" class="relative px-6 py-3 bg-gray-200 ">
                                <span class="sr-only">Edit</span>
                            </th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        @foreach ($orders as $order )
                        <tr>
                            <td class="px-6 py-4 break-all whitespace-nowrap">
                                {{ $order->order_type }}
                            </td>
                            <td class="px-6 py-4 text-sm text-gray-500 break-all">
                                {{ $order->order_description }}
                            </td>
                            <td class="px-3 py-4 text-sm font-light text-gray-900 whitespace-nowrap">
                                @if($order->order_status == '1')
                                <button wire:click="change({{ $order->id }},'0')" type="button"
                                    class="inline-block  px-4 py-2.5 bg-green-500 text-white font-medium text-xs leading-tight uppercase rounded shadow-md hover:bg-green-600 hover:shadow-lg focus:bg-green-600 focus:shadow-lg focus:outline-none focus:ring-0 active:bg-green-700 active:shadow-lg transition duration-150 ease-in-out">
                                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z">
                                        </path>
                                    </svg></button>


                                @else
                                <button type="button" wire:click="change({{ $order->id }},'1')"
                                    class="inline-block px-4 py-2.5 bg-red-600 text-white font-medium text-xs leading-tight uppercase rounded shadow-md hover:bg-red-700 hover:shadow-lg focus:bg-red-700 focus:shadow-lg focus:outline-none focus:ring-0 active:bg-red-800 active:shadow-lg transition duration-150 ease-in-out">
                                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                    </svg></button>

                                @endif
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>


    {{-- Modal Show --}}
    <input type="checkbox" id="create" class="modal-toggle" />
    <div class="modal">
        <div class="w-11/12 max-w-5xl modal-box">
            <label for="create" class="absolute btn btn-sm btn-circle right-2 top-2">✕</label>

            @livewire('mecanic.create-mecanic', ['sale'=>$sale])

        </div>
    </div>

    {{-- Modal Lista --}}
    <input type="checkbox" id="list" class="modal-toggle" />
    <div class="modal">
        <div class="w-11/12 h-full max-w-5xl modal-box ">
            <label for="list" class="absolute btn btn-sm btn-circle right-2 top-2">✕</label>
            @livewire('mecanic.list-mecanic', ['sale'=>$sale->id])
        </div>
    </div>
</div>
