<div>
    <div class="mt-5 overflow-y-auto sm:-mx-6">
        <div class="inline-block py-2 break-all align-middle sm:px-6 lg:px-8">
            <div class="border-gray-200 shadow overflow-y-autoborder-b sm:rounded-lg">
                <table class="w-full divide-y divide-gray-200 table-fixed">
                    <thead class="bg-gray-50">
                        <tr>
                            <th
                                class="w-1/2 px-6 py-3 text-xs font-medium tracking-wider text-left text-gray-800 uppercase bg-gray-200">
                                Comentario
                            </th>
                            <th
                                class="w-1/2 px-6 py-3 text-xs font-medium tracking-wider text-left text-gray-800 uppercase bg-gray-200">
                                Tipo
                            </th>
                            <th scope="col" class="relative px-6 py-3 bg-gray-200 ">
                                <span class="sr-only">Edit</span>
                            </th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        @foreach ($list as $comment )
                        <tr>
                            <td class="px-6 py-4 break-all whitespace-nowrap">
                                @switch( $comment->type_detail)
                                @case(0)
                                Servicio
                                @break
                                @case(1)
                                Producto
                                @break
                                @case(2)
                                Comentario
                                @break

                                @default

                                @endswitch
                            </td>
                            <td class="px-6 py-4 text-sm text-gray-500 break-all">
                                {{ $comment->detail }}
                            </td>
                            <td>
                                <button wire:click="delete({{ $comment }})" type="button"
                                    class="focus:outline-none text-white bg-red-700 hover:bg-red-800 focus:ring-4 focus:ring-red-300 font-medium rounded-lg text-sm px-5 py-2.5 mr-2 mb-2 dark:bg-red-600 dark:hover:bg-red-700 dark:focus:ring-red-900">

                                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor"
                                        viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M15 12H9m12 0a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                    </svg>
                                </button>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
                {{ $list->links() }}
            </div>
        </div>
    </div>
</div>
