<div>
    <div class="relative overflow-x-auto shadow-md sm:rounded-lg">
        <table class="w-full text-sm text-left text-gray-500 dark:text-gray-400">
            <thead class="text-xs text-gray-700 uppercase bg-gray-50 dark:bg-gray-700 dark:text-gray-400">
                <tr>
                    <th scope="col" class="px-6 py-3">
                        PLACA
                    </th>
                    <th scope="col" class="px-6 py-3">
                        PROPIETARIO
                    </th>
                    <th scope="col" class="px-6 py-3">
                        MODELO
                    </th>
                    <th scope="col" class="px-6 py-3">
                        COLOR
                    </th>
                </tr>
            </thead>
            <tbody>
                @foreach ($sales as $item )
                <tr
                    class="border-b dark:bg-gray-800 dark:border-gray-700 odd:bg-white even:bg-gray-50 odd:dark:bg-gray-800 even:dark:bg-gray-700">

                    <th scope="row" class="px-6 py-4 font-medium text-gray-900 dark:text-white whitespace-nowrap">
                        <a href="{{ route('mecanic.show', $item) }}" for="create" wire:click="$set('sale',{{ $item }})"
                            type="button"
                            class="uppercase cursor-pointer py-2.5 px-5 mr-2 mb-2 text-sm font-medium text-gray-900 focus:outline-none bg-white rounded-lg border border-gray-200 hover:bg-gray-100 hover:text-blue-700 focus:z-10 focus:ring-4 focus:ring-gray-200 dark:focus:ring-gray-700 dark:bg-gray-800 dark:text-gray-400 dark:border-gray-600 dark:hover:text-white dark:hover:bg-gray-700">
                            {{ $item->Car->plate }}
                        </a>

                    </th>
                    <td class="px-6 py-4 capitalize">
                        {{ $item->Car->Client->names }}
                    </td>
                    <td class="px-6 py-4 capitalize">
                        {{ $item->Car->model }}
                    </td>
                    <td class="px-6 py-4 capitalize">
                        {{ $item->Car->color }}
                    </td>

                </tr>
                @endforeach
            </tbody>
        </table>
        {{ $sales->links() }}
    </div>
</div>
