<div>
    <div class="hidden sm:block" aria-hidden="true">
        <div class="py-5">
            <div class="border-t border-gray-200"></div>
        </div>
    </div>

    <div>
        <div class="md:grid md:grid-cols-3 md:gap-6">

            <div>
                <form wire:submit.prevent='save'>
                    <div class="overflow-hidden shadow sm:rounded-md">
                        <div class="px-4 py-5 bg-white sm:p-6">
                            <div class="grid grid-cols-6 gap-6">
                                <div class="col-span-6 sm:col-span-3">
                                    <label for="" class="block text-sm font-medium text-gray-700">
                                        Estado del Servicio
                                    </label>
                                    <select wire:model='type_detail' id="" name="country"
                                        class="block w-full px-3 py-2 mt-1 font-medium text-indigo-700 bg-white border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm">
                                        <option value=0 class="font-bold text-green-700">Servicio</option>
                                        <option value=1 class="font-bold text-indigo-700">Producto</option>
                                        <option value=2 class="font-bold text-red-700">Comentario</option>
                                    </select>
                                </div>
                                <div class="col-span-6 sm:col-span-6">
                                    <label for="message"
                                        class="block mb-2 text-sm font-medium text-gray-900 dark:text-gray-400">Comentario</label>
                                    <textarea wire:model="detail" rows="4"
                                        class="block p-2.5 w-full text-sm text-gray-900 bg-gray-50 rounded-lg border border-gray-300 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500"
                                        placeholder="Ingresar tu commentario"></textarea>
                                    @error('detail')
                                    <span class="text-red-700">{{ $message }}</span>
                                    @enderror
                                </div>

                            </div>
                        </div>
                        <div class="px-4 py-3 text-right bg-gray-50 sm:px-6">

                            <button type="submit"
                                class="inline-flex justify-center px-4 py-2 text-sm font-medium text-white bg-indigo-600 border border-transparent rounded-md shadow-sm hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M9 13h6m-3-3v6m5 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z">
                                    </path>
                                </svg>
                            </button>
                        </div>
                    </div>
                </form>
            </div>

        </div>
    </div>

    <div class="hidden sm:block" aria-hidden="true">
        <div class="py-5">
            <div class="border-t border-gray-200"></div>
        </div>
    </div>



</div>
