<div>
    <div class="hidden sm:block" aria-hidden="true">
        <div class="py-5">
            <div class="border-t border-gray-200"></div>
        </div>
    </div>

    <div class="mt-10 sm:mt-0">
        <div class="md:grid md:grid-cols-3 md:gap-6">
            <div class="md:col-span-1">
                <div class="px-4 sm:px-0">
                    <h3 class="text-lg font-medium leading-6 text-gray-900">Información del Cliente</h3>
                    <p class="mt-1 text-sm text-gray-600">
                        La descripción registrada del cliente, será usada en la ventas
                    </p>
                </div>
            </div>
            <div class="mt-5 md:mt-0 md:col-span-2">
                <form wire:submit.prevent='update'>
                    <div class="overflow-hidden shadow sm:rounded-md">
                        <div class="px-4 py-5 bg-white sm:p-6">
                            <div class="grid grid-cols-6 gap-6">

                                <div class="col-span-6 sm:col-span-2">
                                    <label wire:click='generate' class="block text-sm font-medium text-gray-700 cursor-pointer hover:bg-indigo-600 hover:text-white">
                                        DNI
                                    </label>
                                    <input wire:model='dni' autocomplete="off" type="text"
                                        class="block w-full px-3 py-2 mt-1 uppercase bg-white border-2 border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm">
                                    @error('dni')
                                    <span class="error">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div class="col-span-6 sm:col-span-4">
                                    <label for="first-name" class="block text-sm font-medium text-gray-700">
                                        Nombres Completos
                                    </label>
                                    <input wire:model='names' autocomplete="off" type="text"
                                        class="block w-full px-3 py-2 mt-1 uppercase bg-white border-2 border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm">
                                    @error('names')
                                    <span class="error">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div class="col-span-6 sm:col-span-2">
                                    <label class="block text-sm font-medium text-gray-700">
                                        Teléfono <span class="error">*</span>
                                    </label>
                                    <input wire:model='phone' autocomplete="off" type="text" maxlength="12"
                                        class="block w-full px-3 py-2 mt-1 uppercase bg-white border-2 border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm">
                                    @error('phone')
                                    <span class="error">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div class="col-span-6 sm:col-span-2">
                                    <label class="block text-sm font-medium text-gray-700">
                                        RUC <span class="error">*</span>
                                    </label>
                                    <input wire:model='ruc' autocomplete="off" type="text" maxlength="15"
                                        class="block w-full px-3 py-2 mt-1 uppercase bg-white border-2 border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm">
                                    @error('ruc')
                                    <span class="error">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div class="col-span-6 sm:col-span-6">
                                    <label for="first-name" class="block text-sm font-medium text-gray-700">
                                        Dirección <span class="error">*</span>
                                    </label>
                                    <input wire:model='address' autocomplete="off" type="text" maxlength="50"
                                        class="block w-full px-3 py-2 mt-1 capitalize bg-white border-2 border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm">
                                    @error('address')
                                    <span class="error">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="px-4 py-3 text-right bg-gray-50 sm:px-6">
                            <button type="submit"
                                class="inline-flex justify-center px-4 py-2 text-sm font-medium text-white bg-indigo-600 border border-transparent rounded-md shadow-sm hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-refresh"
                                    width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor"
                                    fill="none" stroke-linecap="round" stroke-linejoin="round">
                                    <desc>Download more icon variants from https://tabler-icons.io/i/refresh
                                    </desc>
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                    <path d="M20 11a8.1 8.1 0 0 0 -15.5 -2m-.5 -4v4h4"></path>
                                    <path d="M4 13a8.1 8.1 0 0 0 15.5 2m.5 4v-4h-4"></path>
                                </svg>
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="hidden sm:block" aria-hidden="true">
        <div class="py-5">
            <div class="border-t border-gray-200"></div>
        </div>
    </div>

</div>
