<div class="h-full overflow-x-auto">
    <div class="hidden sm:block" aria-hidden="true">
        <div class="py-5">
            <div class="border-t border-gray-200"></div>
        </div>
    </div>

    <div class="overflow-x-auto shadow-md  sm:rounded-lg">
        <table class="w-full text-sm text-left text-gray-500 dark:text-gray-400">
            <thead class="text-xs text-gray-700 uppercase bg-gray-50 dark:bg-gray-700 dark:text-gray-400">
                <tr>
                    <th scope="col" class="px-6 py-3">
                        N° VENTA
                    </th>
                    <th scope="col" class="px-6 py-3">
                        PLACA
                    </th>
                    <th scope="col" class="px-6 py-3">
                        PROPIETARIO
                    </th>
                    <th scope="col" class="px-6 py-3">
                        TOTAL
                    </th>
                    <th scope="col" class="px-6 py-3">
                        FECHA DE SALIDA
                    </th>
                    <th scope="col" class="px-6 py-3">
                        <span class="sr-only">Edit</span>
                    </th>
                </tr>
            </thead>
            <tbody>
                @foreach ($sales as $sale )
                <tr
                    class="bg-white border-b dark:bg-gray-800 dark:border-gray-700 hover:bg-gray-50 dark:hover:bg-gray-600">
                    <th scope="row" class="px-6 py-4 font-medium text-gray-900 dark:text-white whitespace-nowrap">
                        {{ $sale->id }}
                    </th>
                    <td class="px-6 py-4 uppercase">
                        {{$sale->Car->plate}}
                    </td>
                    <td class="px-6 py-4 capitalize">
                        {{$sale->Car->Client->names}}
                    </td>
                    <td class="px-6 py-4 uppercase">
                        S/. {{number_format($sale->total_sale,2)}}
                    </td>
                    <td class="px-6 py-4 uppercase">
                        {{ $sale->updated_at }}
                    </td>
                    <td class="px-6 py-4 text-right">
                        <label for="sale" wire:click="$set('show',{{ $sale->id }})"
                            class="inline-flex justify-center px-4 py-2 text-sm font-medium text-white bg-indigo-600 border border-transparent rounded-md shadow-sm cursor-pointer hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"
                                xmlns="http://www.w3.org/2000/svg">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-3 7h3m-3 4h3m-6-4h.01M9 16h.01">
                                </path>
                            </svg>
                        </label>
                    </td>
                </tr>
                @endforeach


            </tbody>
        </table>
    </div>


    <div class="hidden sm:block" aria-hidden="true">
        <div class="py-5">
            <div class="border-t border-gray-200"></div>
        </div>
    </div>

    <input type="checkbox" id="sale" class="modal-toggle" />
    <div class="modal">
        <div class="w-11/12 h-full max-w-5xl modal-box max-h-max">
            <label for="sale" wire:click="$set('show',null)"
                class="absolute btn btn-sm btn-circle right-2 top-2">✕</label>
            @if($show)
            @livewire('sale.show-sale',['sale'=>$show])
            @else
            {{ $show }}
            @include('components.load')
            @endif
        </div>
    </div>
</div>
