<div>
    <div class="hidden sm:block" aria-hidden="true">
        <div class="py-5">
            <div class="border-t border-gray-200"></div>
        </div>
    </div>

    <div class="mt-10 sm:mt-0">
        <div class="md:grid md:grid-cols-3 md:gap-6">
            <div class="md:col-span-1">
                <div class="px-4 sm:px-0">
                    <h3 class="text-lg font-medium leading-6 text-gray-900">Información del Vehículo</h3>
                    <p class="mt-1 text-sm text-gray-600">
                        La descripción registrada del vehículo, será usada en la ventas
                    </p>
                </div>
            </div>
            <div class="mt-5 md:mt-0 md:col-span-2">
                <form wire:submit.prevent='save'>
                    <div class="overflow-hidden shadow sm:rounded-md">
                        <div class="px-4 py-5 bg-white sm:p-6">
                            <div class="grid grid-cols-6 gap-6">

                                <div class="col-span-6 sm:col-span-2">
                                    <label class="block text-sm font-medium text-gray-700 ">
                                        Placa
                                    </label>
                                    <input wire:model='plate' autocomplete="off" type="text" maxlength="20"
                                        class="block w-full px-3 py-2 mt-1 uppercase bg-white border-2 border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm">
                                    @error('plate')
                                    <span class="error">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div class="col-span-6 sm:col-span-2">
                                    <label class="block text-sm font-medium text-gray-700">
                                        Motor <span class="error">*</span>
                                    </label>
                                    <input wire:model='engine' autocomplete="off" type="text" maxlength="20"
                                        class="block w-full px-3 py-2 mt-1 capitalize bg-white border-2 border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm">
                                </div>

                                <div class="col-span-6 sm:col-span-2">
                                    <label class="block text-sm font-medium text-gray-700">
                                        Marca <span class="error">*</span>
                                    </label>
                                    <input wire:model='brand' autocomplete="off" type="text" maxlength="20"
                                        class="block w-full px-3 py-2 mt-1 capitalize bg-white border-2 border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm">
                                </div>

                                <div class="col-span-6 sm:col-span-2">
                                    <label class="block text-sm font-medium text-gray-700">
                                        Modelo <span class="error">*</span>
                                    </label>
                                    <input wire:model='model' autocomplete="off" type="text" maxlength="20"
                                        class="block w-full px-3 py-2 mt-1 capitalize bg-white border-2 border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm">
                                </div>

                                <div class="col-span-6 sm:col-span-2">
                                    <label class="block text-sm font-medium text-gray-700">
                                        Chasis <span class="error">*</span>
                                    </label>
                                    <input wire:model='chassis' autocomplete="off" type="text" maxlength="20"
                                        class="block w-full px-3 py-2 mt-1 capitalize bg-white border-2 border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm">
                                </div>

                                <div class="col-span-6 sm:col-span-2">
                                    <label class="block text-sm font-medium text-gray-700">
                                        Año <span class="error">*</span>
                                    </label>
                                    <input wire:model='year' maxlength="4" autocomplete="off" type="text"
                                        class="block w-full px-3 py-2 mt-1 capitalize bg-white border-2 border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm">
                                </div>

                                <div class="col-span-6 sm:col-span-2">
                                    <label class="block text-sm font-medium text-gray-700">
                                        Color <span class="error">*</span>
                                    </label>
                                    <input list="colors" wire:model='color' autocomplete="off" type="text"
                                        maxlength="20"
                                        class="block w-full px-3 py-2 mt-1 capitalize bg-white border-2 border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm">

                                    <datalist id="colors">
                                        <option value="Negro">
                                        <option value="Azul">
                                        <option value="Blanco">
                                        <option value="Rojo">
                                        <option value="Naranja">
                                        <option value="Gris">
                                    </datalist>
                                </div>

                                <div class="col-span-6 sm:col-span-4">
                                    <label class="block text-sm font-medium text-gray-700">
                                        Cliente
                                    </label>
                                    <input disabled wire:model='client' autocomplete="off" type="text"
                                        class="block w-full px-3 py-2 mt-1 capitalize bg-white border-2 border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm">
                                    @error('client')
                                    <span class="error">{{ $message }}</span>
                                    @enderror
                                </div>

                            </div>
                        </div>
                        <div class="px-4 py-3 text-right bg-gray-50 sm:px-6">
                            <label for="searchx"
                                class="inline-flex justify-center px-4 py-2 text-sm font-medium text-white bg-indigo-600 border border-transparent rounded-md shadow-sm cursor-pointer hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-user-search"
                                    width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor"
                                    fill="none" stroke-linecap="round" stroke-linejoin="round">
                                    <desc>Download more icon variants from https://tabler-icons.io/i/user-search</desc>
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                    <circle cx="12" cy="7" r="4"></circle>
                                    <path d="M6 21v-2a4 4 0 0 1 4 -4h1"></path>
                                    <circle cx="16.5" cy="17.5" r="2.5"></circle>
                                    <path d="M18.5 19.5l2.5 2.5"></path>
                                </svg>
                            </label>
                            <button type="submit"
                                class="inline-flex justify-center px-4 py-2 text-sm font-medium text-white bg-indigo-600 border border-transparent rounded-md shadow-sm hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-apps"
                                    width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor"
                                    fill="none" stroke-linecap="round" stroke-linejoin="round">
                                    <desc>Download more icon variants from https://tabler-icons.io/i/apps</desc>
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                    <rect x="4" y="4" width="6" height="6" rx="1"></rect>
                                    <rect x="4" y="14" width="6" height="6" rx="1"></rect>
                                    <rect x="14" y="14" width="6" height="6" rx="1"></rect>
                                    <line x1="14" y1="7" x2="20" y2="7"></line>
                                    <line x1="17" y1="4" x2="17" y2="10"></line>
                                </svg>
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="hidden sm:block" aria-hidden="true">
        <div class="py-5">
            <div class="border-t border-gray-200"></div>
        </div>
    </div>


    {{-- Modal Create --}}
    <input type="checkbox" id="searchx" class="modal-toggle" />
    <div class="modal">
        <div class="w-11/12 max-w-5xl modal-box">
            <label for="searchx" class="absolute btn btn-sm btn-circle right-2 top-2">✕</label>
            {{-- Buscador --}}
            <div class="flex p-4">
                <div class="relative w-full ">
                    <div class="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none">
                        <svg class="w-5 h-5 text-gray-500 dark:text-gray-400" fill="currentColor" viewBox="0 0 20 20"
                            xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd"
                                d="M8 4a4 4 0 100 8 4 4 0 000-8zM2 8a6 6 0 1110.89 3.476l4.817 4.817a1 1 0 01-1.414 1.414l-4.816-4.816A6 6 0 012 8z"
                                clip-rule="evenodd"></path>
                        </svg>
                    </div>
                    <input type="text" wire:model='search'
                        class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full pl-10 p-2.5  dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500"
                        placeholder="Buscar Propietario" autocomplete="off">
                </div>
            </div>

            {{-- Tabla --}}
            <div class="relative mb-5 overflow-x-auto shadow-md sm:rounded-lg">

                <table class="w-full text-sm text-left text-gray-500 dark:text-gray-400">
                    <thead class="text-xs text-gray-700 uppercase bg-gray-50 dark:bg-gray-700 dark:text-gray-400">
                        <tr>
                            <th scope="col" class="px-6 py-3">
                                DNI
                            </th>
                            <th scope="col" class="px-6 py-3">
                                NOMBRES COMPLETOS
                            </th>
                            <th scope="col" class="px-6 py-3 text-center">
                                TELÉFONO
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse ($clients as $item )
                        <tr wire:click="select({{ $item }})"
                            class="bg-white border-b cursor-pointer dark:bg-gray-800 dark:border-gray-700 hover:bg-gray-50 dark:hover:bg-gray-600">
                            <th scope="row"
                                class="px-6 py-4 font-medium text-gray-900 capitalize dark:text-white whitespace-nowrap">
                                {{$item->dni}}
                            </th>
                            <td class="px-6 py-4 capitalize">
                                {{ $item->names }}
                            </td>
                            <td class="px-6 py-4 text-center">
                                {{ $item->phone }}
                            </td>
                        </tr>
                        @empty
                        <h1 class="p-2 text-lg font-bold text-red-700">No se encontraron resultados</h1>
                        @endforelse

                    </tbody>
                </table>
                {{ $clients->links() }}
            </div>
        </div>
    </div>


</div>