<div>
    <div class="font">
        {{-- Header --}}
        <div class="grid grid-cols-12 ">
            <div class="col-span-2 text-center ">
                <img class="w-24 h-24" src="{{ asset('img/logo.png') }}" alt="">
            </div>
            <div class="col-span-10 pr-2 text-right">
                <div>
                    <label class="text-2xl font-bold">COTIZACIÓN</label> <br>
                    <label class="text-xl font-bold text-red-600">
                        N° {{ str_pad($calculate->id, 6, '0', STR_PAD_LEFT) }}
                    </label>
                </div>
                <p class="text-xs text-left">
                    Servicio de reparación y mantenimiento en general de gasolinera y diesel, maquinarias pesadas,
                    electricidad
                    y electrónica
                    soldadura autógena y eléctrica venta de repuestos y lubricantes en todas marcas, venta de
                    filtros
                    nacionales
                    e importados. <br>
                    <label class="font-bold">DE: Lido Salazar Córdova</label>
                </p>
            </div>
        </div>
        {{-- Datos del Conductor --}}
        <div class="grid grid-cols-12 mt-3">
            <div class="col-span-4 text-center border-t border-l border-r border-indigo-600">
                <label class="font-bold text-blue-600">Fecha de Ingreso: </label>
                <label class="font-bold">{{ $calculate->created_at->format('d-m-Y') }}</label>
            </div>
            <div class="col-span-4 text-center border-t border-indigo-600">
                <label for="create" type="button"
                    class="w-full p-1 text-sm font-medium text-white bg-blue-700 cursor-pointer hover:bg-blue-800 focus:ring-4 focus:ring-blue-300 dark:bg-blue-600 dark:hover:bg-blue-700 focus:outline-none dark:focus:ring-blue-800">
                    + AGREGAR
                </label>
            </div>
            <div class="col-span-4 text-center border-t border-l border-r border-indigo-600">
                <label class="font-bold text-blue-600">Fecha de Salida: </label>
                <label class="font-bold">{{ $calculate->updated_at->format('d-m-Y') }}</label>
            </div>
            <div class="col-span-12 text-center border border-indigo-600">
                <label class="font-bold text-blue-600">DATOS DEL RECEPTOR / CONDUCTOR</label>
            </div>

            <div class="col-span-6 pl-3 border-b border-l border-r border-indigo-600">
                <label class="font-bold text-blue-600">Propietario: </label>
                <label class="font-bold capitalize">{{ $calculate->property_calculate }}</label>
            </div>

            <div class="col-span-6 pl-3 border-b border-r border-indigo-600">
                <label class="font-bold text-blue-600">Conductor: </label>
                <label class="font-bold capitalize">{{ $calculate->driver_calculate }}</label>
            </div>

            <div class="col-span-6 pl-3 uppercase border-b border-l border-r border-indigo-600">
                <label class="font-bold text-blue-600">R.U.C: </label>
                <label class="font-bold">{{ $calculate->ruc_calculate }}</label>
            </div>

            <div class="col-span-6 pl-3 uppercase border-b border-r border-indigo-600">
                <label class="font-bold text-blue-600">D.N.I: </label>
                <label class="font-bold">{{ $calculate->dni_calculate }}</label>
            </div>

            <div class="col-span-4 pl-3 border-b border-l border-r border-indigo-600">
                <label class="font-bold text-blue-600">Teléfono: </label>
                <label class="font-bold uppercase">{{ $calculate->phone_calculate }}</label>
            </div>
            <div class="col-span-4 pl-3 border-b border-l border-r border-indigo-600">
                @if ($calculate->celp_calculate)
                <label class="font-bold text-blue-600">Celular: </label>
                <label class="font-bold uppercase">{{ $calculate->celp_calculate }}</label>
                @endif
            </div>

            <div class="col-span-4 pl-3 border-b border-r border-indigo-600">
                <label class="font-bold text-blue-600">Celular: </label>
                <label class="font-bold uppercase">{{ $calculate->celd_calculate }}</label>
            </div>

            <div class="col-span-12 pl-3 border-b border-l border-r border-indigo-600">
                <label class="font-bold text-blue-600">Dirección: </label>
                <label class="font-bold capitalize">{{ $calculate->address_calculate }}</label>
            </div>



        </div>

        {{-- Datos del Vehículo --}}
        <div class="grid grid-cols-12 mt-3">
            <div class="col-span-12 text-center border border-indigo-600">
                <label class="font-bold text-blue-600">
                    DATOS DEL VEHÍCULO
                </label>
            </div>

            <div class="col-span-4 pl-3 border-b border-l border-r border-indigo-600">
                <label class="font-bold text-blue-600">Placa: </label>
                <label class="font-bold uppercase">{{ $calculate->plate_calculate }}</label>
            </div>

            <div class="col-span-4 pl-3 border-b border-r border-indigo-600">
                <label class="font-bold text-blue-600">N° Motor: </label>
                <label class="font-bold uppercase">{{ $calculate->engine_calculate }}</label>
            </div>
            <div class="col-span-4 pl-3 border-b border-r border-indigo-600">
                <label class="font-bold text-blue-600">N° Chasis: </label>
                <label class="font-bold uppercase">{{ $calculate->chassis_calculate }}</label>
            </div>

            <div class="col-span-4 pl-3 border-b border-l border-r border-indigo-600">
                <label class="font-bold text-blue-600">Marca: </label>
                <label class="font-bold capitalize">{{ $calculate->brand_calculate }}</label>
            </div>

            <div class="col-span-4 pl-3 border-b border-r border-indigo-600">
                <label class="font-bold text-blue-600">Modelo: </label>
                <label class="font-bold capitalize">{{ $calculate->model_calculate }}</label>
            </div>
            <div class="col-span-4 pl-3 border-b border-r border-indigo-600">
                <label class="font-bold text-blue-600">Año: </label>
                <label class="font-bold uppercase">{{ $calculate->year_car_calculate }}</label>
            </div>

            <div class="col-span-4 pl-3 border-b border-l border-r border-indigo-600">
                <label class="font-bold text-blue-600">Color: </label>
                <label class="font-bold capitalize">{{ $calculate->color_calculate }}</label>
            </div>

            <div class="col-span-4 text-center border-b border-r border-indigo-600 ">
                <a target="_blank" href="{{ route('pdf.calculate', $calculate) }}" type="button"
                    class="w-full p-1 text-sm font-medium text-white bg-green-700 cursor-pointer hover:bg-green-800 focus:ring-4 focus:ring-green-300 dark:bg-green-600 dark:hover:bg-green-700 focus:outline-none dark:focus:ring-green-800">
                    IMPRIMIR
                </a>
            </div>
            <div class="col-span-4 pl-3 border-b border-r border-indigo-600">
                <label class="font-bold text-blue-600">Recorrido KM: </label>
                <label class="font-bold capitalize">{{ $calculate->km_calculate }}</label>
            </div>

        </div>

        {{-- Items --}}
        @if (count($items))
        <div class="grid grid-cols-12 mt-3">
            {{-- <div class="col-span-12 text-center border border-indigo-600">
                <label class="font-bold text-blue-600">
                    itemOS AGREGADOS
                </label>
            </div> --}}
            <div class="col-span-12 text-center border-b border-indigo-600">

            </div>
            <div class="col-span-1 pl-3 text-center border-b border-l border-r border-indigo-600">
                <label class="font-bold text-blue-600">CANT</label>
            </div>

            <div class="col-span-4 pl-3 border-b border-r border-indigo-600">
                <label class="font-bold text-blue-600">DESCRIPCIÓN</label>
            </div>

            <div class="col-span-3 pl-3 border-b border-r border-indigo-600">
                <label class="font-bold text-blue-600">MARCA</label>
            </div>

            <div class="col-span-1 pl-3 text-center border-b border-r border-indigo-600">
                <label class="font-bold text-blue-600">P. UNIT</label>
            </div>

            <div class="col-span-2 pl-3 text-center border-b border-r border-indigo-600">
                <label class="font-bold text-blue-600">TOTAL</label>
            </div>
            <div class="col-span-1 pl-3 text-center border-b border-r border-indigo-600">
                <label class="font-bold text-blue-600">ELIMINAR</label>
            </div>

            @foreach ($items as $item)
            <div class="col-span-1 pl-3 text-center border-b border-l border-r border-indigo-600">
                <label class="font-bold uppercase">{{ $item->amount_item }}</label>
            </div>

            <div class="col-span-4 pl-3 border-b border-r border-indigo-600">
                <label class="font-bold capitalize">{{ $item->description_item }}</label>
            </div>

            <div class="col-span-3 pl-3 border-b border-r border-indigo-600">
                <label class="font-bold capitalize">{{ $item->brand_item }}</label>
            </div>

            <div class="col-span-1 pl-3 text-center border-b border-r border-indigo-600">
                <label class="font-bold uppercase">S/.{{ number_format($item->price_item, 2) }}</label>
            </div>

            <div class="col-span-2 pl-3 text-center border-b border-r border-indigo-600">
                <label class="font-bold capitalize">S/.{{ number_format($item->amount_item * $item->price_item, 2)
                    }}</label>

                <div class="hidden">
                    {{ $total_items += $item->amount_item * $item->price_item }}
                </div>
            </div>
            <div class=" flex col-span-1 text-center border-b border-r border-indigo-600 ">
                <label wire:click="$set('item_select',{{ $item->id }})" for="edit" type="button"
                    class="cursor-pointer w-full px-2 py-1 text-sm font-medium text-white bg-green-700 focus:outline-none hover:bg-green-800 focus:ring-4 focus:ring-green-300 dark:bg-green-600 dark:hover:bg-green-700 dark:focus:ring-green-900"><svg
                        xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                        stroke="currentColor" class="w-6 h-6">
                        <path stroke-linecap="round" stroke-linejoin="round"
                            d="M16.862 4.487l1.687-1.688a1.875 1.875 0 112.652 2.652L10.582 16.07a4.5 4.5 0 01-1.897 1.13L6 18l.8-2.685a4.5 4.5 0 011.13-1.897l8.932-8.931zm0 0L19.5 7.125M18 14v4.75A2.25 2.25 0 0115.75 21H5.25A2.25 2.25 0 013 18.75V8.25A2.25 2.25 0 015.25 6H10" />
                    </svg>
                </label>
                <button wire:click="delete({{ $item->id }})" type="button"
                    class="w-full px-2 py-1 text-sm font-medium text-white bg-red-700 focus:outline-none hover:bg-red-800 focus:ring-4 focus:ring-red-300 dark:bg-red-600 dark:hover:bg-red-700 dark:focus:ring-red-900">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                        stroke="currentColor" class="w-6 h-6">
                        <path stroke-linecap="round" stroke-linejoin="round"
                            d="M14.74 9l-.346 9m-4.788 0L9.26 9m9.968-3.21c.342.052.682.107 1.022.166m-1.022-.165L18.16 19.673a2.25 2.25 0 01-2.244 2.077H8.084a2.25 2.25 0 01-2.244-2.077L4.772 5.79m14.456 0a48.108 48.108 0 00-3.478-.397m-12 .562c.34-.059.68-.114 1.022-.165m0 0a48.11 48.11 0 013.478-.397m7.5 0v-.916c0-1.18-.91-2.164-2.09-2.201a51.964 51.964 0 00-3.32 0c-1.18.037-2.09 1.022-2.09 2.201v.916m7.5 0a48.667 48.667 0 00-7.5 0" />
                    </svg>
                </button>
            </div>
            @endforeach
            <div class="col-span-9 pr-3 text-right border-b border-l border-r border-indigo-600">
                <label class="font-bold text-indigo-600 capitalize">TOTAL: </label>
            </div>
            <div class="col-span-2 pl-3 text-center border-b border-r border-indigo-600">
                <label class="font-bold capitalize">S/.{{ number_format($total_items, 2) }}</label>
            </div>
        </div>


        @endif

        {{-- Agregar --}}
        <input type="checkbox" id="create" class="modal-toggle" />
        <div class="modal">
            <div class="w-11/12 max-w-5xl modal-box">
                <label for="create" class="absolute btn btn-sm btn-circle right-2 top-2">✕</label>
                @livewire('calculate.add-item', ['calculate' => $calculate])
            </div>
        </div>

        {{-- Editar --}}
        <input type="checkbox" id="edit" class="modal-toggle" />
        <div class="modal">
            <div class="w-11/12 max-w-5xl modal-box">
                <label for="edit" class="absolute btn btn-sm btn-circle right-2 top-2"
                    wire:click="$set('item_select',null)">✕</label>
                @if ($item_select)
                @livewire('calculate.edit-item', ['item' => $item_select])
                @endif

            </div>
        </div>
    </div>
</div>
