<div>
    {{-- Tabla --}}
    <div class="relative overflow-x-auto shadow-md sm:rounded-lg">
        <div class="p-4 text-right">
            <label for="create" type="button"
                class="ml-2 cursor-pointer text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:ring-blue-300 font-medium rounded-lg text-sm px-5 py-2.5 mr-2 mb-2 dark:bg-blue-600 dark:hover:bg-blue-700 focus:outline-none dark:focus:ring-blue-800">
                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"
                    xmlns="http://www.w3.org/2000/svg">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                        d="M17 14v6m-3-3h6M6 10h2a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v2a2 2 0 002 2zm10 0h2a2 2 0 002-2V6a2 2 0 00-2-2h-2a2 2 0 00-2 2v2a2 2 0 002 2zM6 20h2a2 2 0 002-2v-2a2 2 0 00-2-2H6a2 2 0 00-2 2v2a2 2 0 002 2z">
                    </path>
                </svg>
            </label>
        </div>

        <table class="w-full text-sm text-left text-gray-500 dark:text-gray-400">
            <thead class="text-xs text-gray-700 uppercase bg-gray-50 dark:bg-gray-700 dark:text-gray-400">
                <tr>
                    <th scope="col" class="px-6 py-3">
                        N°
                    </th>
                    <th scope="col" class="px-6 py-3">
                        PLACA
                    </th>
                    <th scope="col" class="px-6 py-3">
                        MODELO
                    </th>
                    <th scope="col" class="px-6 py-3">
                        RUC
                    </th>
                    <th scope="col" class="px-6 py-3">
                        PROPIETARIO
                    </th>
                    <th scope="col" class="px-6 py-3">
                        CONDUCTOR
                    </th>
                    <th scope="col" class="px-6 py-3">
                        ESTADO
                    </th>
                    <th scope="col" class="px-6 py-3">
                        <span class="sr-only">Edit</span>
                    </th>
                </tr>
            </thead>
            <tbody>
                @foreach ($calculates as $calculate )
                <tr
                    class="bg-white border-b dark:bg-gray-800 dark:border-gray-700 hover:bg-gray-50 dark:hover:bg-gray-600">
                    <th scope="row" class="px-6 py-4 font-medium text-gray-900 dark:text-white whitespace-nowrap">
                        {{ $calculate->id }}
                    </th>
                    <th scope="row"
                        class="px-6 py-4 font-medium text-gray-900 uppercase dark:text-white whitespace-nowrap">
                        {{ $calculate->plate_calculate }}
                    </th>
                    <td class="px-6 py-4 capitalize">
                        {{ $calculate->model_calculate }}
                    </td>
                    <td class="px-6 py-4 capitalize">
                        {{ $calculate->ruc_calculate }}
                    </td>
                    <td class="px-6 py-4 capitalize">
                        {{ $calculate->property_calculate }}
                    </td>
                    <td class="px-6 py-4 capitalize">
                        {{ $calculate->driver_calculate }}
                    </td>
                    <td class="px-6 py-4 uppercase">
                        @if($calculate->status_calculate == '1')
                        <span class="px-2 py-1 font-semibold leading-tight text-blue-600 bg-indigo-100 rounded-sm">
                            VALIDO
                        </span>
                        @else
                        <span class="px-2 py-1 font-semibold leading-tight text-red-600 bg-red-100 rounded-sm">
                            INVALIDO
                        </span>
                        @endif
                    </td>
                    <td class="px-6 py-4 text-right">
                        <a href="{{ route('calculate.show', $calculate) }}" type="button"
                            class="p-2 text-sm font-medium text-white bg-blue-700 rounded-lg hover:bg-blue-800 focus:ring-4 focus:ring-blue-300 dark:bg-blue-600 dark:hover:bg-blue-700 focus:outline-none dark:focus:ring-blue-800">
                            <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-eye-check"
                                width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor"
                                fill="none" stroke-linecap="round" stroke-linejoin="round">
                                <desc>Download more icon variants from https://tabler-icons.io/i/eye-check</desc>
                                <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                <circle cx="12" cy="12" r="2"></circle>
                                <path
                                    d="M12 19c-4 0 -7.333 -2.333 -10 -7c2.667 -4.667 6 -7 10 -7s7.333 2.333 10 7c-.42 .736 -.858 1.414 -1.311 2.033">
                                </path>
                                <path d="M15 19l2 2l4 -4"></path>
                            </svg></a>
                        @if($calculate->status_calculate == '1')
                        <label wire:click="question({{ $calculate }})" type="button"
                            class="p-2 text-sm font-medium text-white bg-red-700 rounded-lg cursor-pointer hover:bg-red-800 focus:ring-4 focus:ring-red-300 dark:bg-red-600 dark:hover:bg-red-700 focus:outline-none dark:focus:ring-red-800">
                            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"
                                xmlns="http://www.w3.org/2000/svg">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M6 18L18 6M6 6l12 12"></path>
                            </svg></label>
                        @endif
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
        {{ $calculates->links() }}
    </div>

    {{-- Modal Create --}}
    <input type="checkbox" id="create" class="modal-toggle" />
    <div class="modal">
        <div class="w-11/12 max-w-5xl modal-box">
            <label for="create" class="absolute btn btn-sm btn-circle right-2 top-2">✕</label>
            @livewire('calculate.create-calculate')
        </div>
    </div>
</div>
