<div>
    <form wire:submit.prevent='save'>
        <div class="grid grid-cols-6 gap-2">
            <div class="col-span-6 sm:col-span-6">
                <label class="font-bold text-gray-500">EDITAR DATOS PRODUCTO / SERVICIO</label>
            </div>
            <div class="col-span-6 sm:col-span-1">
                <label class="block mb-2 text-sm font-medium text-gray-900 dark:text-gray-300">
                    Cantidad
                </label>
                <input wire:model='amount_item' type="number" autocomplete="off"
                    class="capitalize bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 focus:outline-none dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
                @error('amount_item')
                <span class="error">{{ $message }}</span>
                @enderror
            </div>
            <div class="col-span-6 sm:col-span-4">
                <label class="block mb-2 text-sm font-medium text-gray-900 dark:text-gray-300">
                    Descripción
                </label>
                <input wire:model='description_item' type="text" autocomplete="off"
                    class="capitalize bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 focus:outline-none dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
                @error('description_item')
                <span class="error">{{ $message }}</span>
                @enderror
            </div>
            <div class="col-span-6 sm:col-span-1">
                <label class="block mb-2 text-sm font-medium text-gray-900 dark:text-gray-300">
                    Precio Unitario
                </label>
                <input wire:model='price_item' type="number" step=".01" autocomplete="off"
                    class="capitalize bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 focus:outline-none dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
                @error('price_item')
                <span class="error">{{ $message }}</span>
                @enderror
            </div>
            <div class="col-span-6 sm:col-span-3">
                <label class="block mb-2 text-sm font-medium text-gray-900 dark:text-gray-300">
                    Marca <span class="error">*</span>
                </label>
                <input wire:model='brand_item' type="text" autocomplete="off"
                    class="capitalize bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 focus:outline-none dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
                @error('brand_item')
                <span class="error">{{ $message }}</span>
                @enderror
            </div>


            <div class="col-span-6 sm:col-span-6">
                <button type="submit"
                    class="text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 font-medium rounded-lg text-sm w-full sm:w-auto px-5 py-2.5 text-center dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"
                        xmlns="http://www.w3.org/2000/svg">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M12 9v3m0 0v3m0-3h3m-3 0H9m12 0a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg></button>
            </div>
        </div>
    </form>

</div>
