<div>
    <div class="relative overflow-x-auto">
        <header class="px-5 py-4 bg-blue-500 border-b border-blue-500">
            <h2 class="font-semibold text-gray-100">
                Servicios - Reportes
            </h2>
        </header>
        <table class="w-full text-sm text-left text-gray-500 dark:text-gray-400">
            <thead class="text-xs text-gray-700 uppercase bg-gray-100 dark:bg-gray-700 dark:text-gray-400">
                <tr>
                    <th scope="col" class="px-6 py-3 rounded-l-lg">
                        N° Venta
                    </th>
                    <th scope="col" class="px-6 py-3 rounded-l-lg">
                        Descripción
                    </th>
                    <th scope="col" class="px-6 py-3">
                        Precio
                    </th>
                </tr>
            </thead>
            <tbody>

                @foreach ($sales as $sale )
                @foreach ($sale->Service as $service )
                <tr class="bg-white dark:bg-white-800">
                    <th scope="row" class="px-6 py-4 font-bold text-black capitalize whitespace-nowrap">
                        {{ $sale->id }}
                    </th>
                    <th scope="row" class="px-6 py-4 font-bold text-black capitalize whitespace-nowrap">
                        {{ $service->description_service }}
                    </th>
                    <td class="px-6 py-4 font-bold">
                        <label class="text-blue-700">
                            S/. {{ number_format($service->pivot->price_sale_service,2) }}
                        </label>
                    </td>
                </tr>
                <div class="hidden">
                    {{ $total += $service->pivot->price_sale_service }}
                </div>
                @endforeach
                @endforeach
            </tbody>
            <tfoot>
                <tr class="font-semibold text-gray-900 bg-gray-200 ">
                    <th scope="row" class="px-6 py-3 text-base"></th>
                    <td class="px-6 py-3">TOTAL</td>
                    <td class="px-6 py-3 text-lg font-bold text-green-700">
                        S/. {{ number_format($total,2)}}
                    </td>
                </tr>
            </tfoot>
        </table>
    </div>
</div>
