<div>
    <div class="relative overflow-x-auto">
        <header class="px-5 py-4 border-b border-gray-100 ">
            <h2 class="font-semibold ">
                Ventas
            </h2>
        </header>
        <table class="w-full text-sm text-left text-gray-500 dark:text-gray-400">
            <thead class="text-xs text-gray-700 uppercase bg-gray-100 dark:bg-gray-700 dark:text-gray-400">
                <tr>
                    <th scope="col" class="px-6 py-3 rounded-l-lg">
                        N° VENTA
                    </th>
                    <th scope="col" class="px-6 py-3 rounded-l-lg">
                        Cuenta
                    </th>
                    <th scope="col" class="px-6 py-3">
                        TOTAL
                    </th>
                    <th scope="col" class="px-6 py-3">
                        DESCUENTO
                    </th>
                    <th scope="col" class="px-6 py-3 rounded-r-lg">
                        ADELANTO
                    </th>
                    <th scope="col" class="px-6 py-3 rounded-r-lg">
                        TOTAL
                    </th>
                    <th scope="col" class="px-6 py-3 rounded-r-lg">

                    </th>
                </tr>
            </thead>
            <tbody>
                @foreach ($sales as $sale )
                <tr class="bg-white dark:bg-white-800">
                    <th scope="row" class="px-6 py-4 font-bold text-black capitalize whitespace-nowrap">
                        {{ $sale->id }}
                    </th>
                    <td class="px-6 py-4 font-bold text-black capitalize">
                        {{ $sale->BankAccount->name}}
                    </td>
                    <td class="px-6 py-4 font-bold text-black capitalize">
                        S/. {{ number_format($sale->total_sale,2) }}
                    </td>
                    <td class="px-6 py-4 font-bold text-black capitalize">
                        S/. {{ number_format($sale->total_discount_sale,2) }}
                    </td>
                    <td class="px-6 py-4 font-bold text-black capitalize">
                        S/. {{ number_format($sale->total_advance,2) }}
                    </td>
                    <td class="px-6 py-4 font-bold text-black capitalize">
                        S/. {{ number_format($sale->total_sale - ( $sale->total_discount_sale +
                        $sale->total_advance),2) }}
                    </td>
                </tr>
                @endforeach
            </tbody>
            <tfoot>
                <tr class="font-semibold text-gray-900 bg-gray-200 ">
                    <th scope="row" class="px-6 py-3 text-base">Total</th>
                    <td class="px-6 py-3"></td>
                    <td class="px-6 py-3 ">

                    </td>
                    <td class="px-6 py-3"></td>
                    <td class="px-6 py-3"></td>
                    <td class="px-6 py-3 text-lg font-bold">
                        <label class="text-green-700">
                            S/. {{ number_format($total,2) }}
                        </label>
                    </td>
                    <td class="px-6 py-3"></td>
                </tr>
            </tfoot>
        </table>
    </div>
</div>
