<div>
    <div class="relative overflow-x-auto">
        <header class="px-5 py-4 border-b border-gray-100">
            <h2 class="font-semibold text-gray-800">
                Movimientos
            </h2>
        </header>
        <table class="w-full text-sm text-left text-gray-500 dark:text-gray-400">
            <thead class="text-xs text-gray-700 uppercase bg-gray-100 dark:bg-gray-700 dark:text-gray-400">
                <tr>
                    <th scope="col" class="px-6 py-3 rounded-l-lg">
                        Concepto
                    </th>
                    <th scope="col" class="px-6 py-3">
                        Entidad
                    </th>
                    <th scope="col" class="px-6 py-3">
                        Cuenta
                    </th>
                    <th scope="col" class="px-6 py-3 rounded-r-lg">
                        Monto
                    </th>
                    <th scope="col" class="px-6 py-3 rounded-r-lg">

                    </th>
                </tr>
            </thead>
            <tbody>
                @foreach ($movemets as $movemet )
                <tr class="bg-white dark:bg-white-800">
                    <th scope="row" class="px-6 py-4 font-bold text-black capitalize whitespace-nowrap">
                        {{ $movemet->concept }}
                    </th>
                    <td class="px-6 py-4 font-bold text-black capitalize">
                        {{ $movemet->person }}
                    </td>
                    <td class="px-6 py-4 font-bold text-black capitalize">
                        {{ $movemet->BankAccount->name }}
                    </td>
                    <td class="px-6 py-4 font-bold">
                        @if($movemet->total_movement > 0)
                        <label class="text-blue-700"> S/. {{ number_format($movemet->total_movement,2) }}</label>
                        @else
                        <label class="text-red-700"> S/. {{ number_format($movemet->total_movement,2) }}</label>
                        @endif
                    </td>
                    <td class="px-6 py-4 capitalize">
                        <button wire:click="delete({{ $movemet }})" type="button"
                            class="px-1 py-1 text-sm font-medium text-white bg-red-700 rounded-lg focus:outline-none hover:bg-red-800 focus:ring-4 focus:ring-red-300 dark:bg-red-600 dark:hover:bg-red-700 dark:focus:ring-red-900">
                            Eliminar</button>

                    </td>
                </tr>
                @endforeach
            </tbody>
            <tfoot>
                <tr class="font-semibold text-gray-900 bg-gray-200 ">
                    <th scope="row" class="px-6 py-3 text-base">Total</th>
                    <td class="px-6 py-3"></td>
                    <td class="px-6 py-3"></td>
                    <td class="px-6 py-3 text-lg font-bold">
                        <label class="text-green-700"> S/. {{ number_format($movemets->sum('total_movement'),2)
                            }}</label>
                    </td>
                    <td class="px-6 py-3"></td>
                </tr>
            </tfoot>
        </table>
    </div>
</div>
