<div>
    <div class="relative overflow-x-auto">
        <header class="px-5 py-4 border-b border-gray-100">
            <h2 class="font-semibold text-gray-800">
                Adelantos
            </h2>
        </header>
        <table class="w-full text-sm text-left text-gray-500 dark:text-gray-400">
            <thead class="text-xs text-gray-700 uppercase bg-gray-100 dark:bg-gray-700 dark:text-gray-400">
                <tr>
                    <th scope="col" class="px-6 py-3 rounded-l-lg">
                        N° VENTA
                    </th>
                    <th scope="col" class="px-6 py-3 rounded-l-lg">
                        Cuenta
                    </th>
                    <th scope="col" class="px-6 py-3">
                        TOTAL
                    </th>
                </tr>
            </thead>
            <tbody>
                @foreach ($advances as $advance )
                <tr class="bg-white dark:bg-white-800">
                    <th scope="row" class="px-6 py-4 font-bold text-black capitalize whitespace-nowrap">
                        {{ $advance->sale_id }}
                    </th>
                    <td class="px-6 py-4 font-bold text-black capitalize">
                        {{ $advance->BankAccount->name}}
                    </td>
                    <td class="px-6 py-4 font-bold text-black capitalize">
                        S/. {{ number_format($advance->total_advance,2 )}}
                    </td>
                </tr>
                @endforeach
            </tbody>
            <tfoot>
                <tr class="font-semibold text-gray-900 bg-gray-200 ">
                    <th scope="row" class="px-6 py-3 text-base">Total</th>
                    <td class="px-6 py-3"></td>
                    <td class="px-6 py-3 text-lg font-bold">
                        <label class="text-green-700">
                            S/. {{ number_format($advances->sum('total_advance'),2) }}
                        </label>
                    </td>
                </tr>
            </tfoot>
        </table>
    </div>
</div>
