<div>
    <form wire:submit.prevent='save'>
        <div class="overflow-hidden shadow sm:rounded-md">
            <div class="px-4 py-5 bg-white sm:p-6">
                <div class="grid grid-cols-6 gap-6 ">

                    <div class="col-span-6 sm:col-span-2">
                        <label class="block text-sm font-medium text-gray-700 ">
                            Cuenta Bancaria
                        </label>
                        <select wire:model="bank_account_id"
                            class="block w-full px-3 py-2 mt-1 uppercase bg-white border-2 border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm">
                            <option disabled value=null>Selecciona una Cuenta</option>
                            @foreach ($banks as $bank )
                            <option value="{{ $bank->id }}">{{ $bank->name }}
                            </option>
                            @endforeach
                        </select>
                        @error('bank_account_id')
                        <span class="error">*{{ $message }}</span>
                        @enderror

                    </div>

                    <div class="col-span-6 sm:col-span-2">
                        <label class="block text-sm font-medium text-gray-700">
                            Concepto
                        </label>
                        <input wire:model='concept' autocomplete="off" type="text" maxlength="100"
                            class="block w-full px-3 py-2 mt-1 capitalize bg-white border-2 border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm">

                        @error('concept')
                        <span class="error">*{{ $message }}</span>
                        @enderror
                    </div>

                    <div class="col-span-6 sm:col-span-2">
                        <label class="block text-sm font-medium text-gray-700">
                            Persona / Entidad
                        </label>
                        <input wire:model='person' autocomplete="off" type="text" maxlength="50"
                            class="block w-full px-3 py-2 mt-1 capitalize bg-white border-2 border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm">

                        @error('person')
                        <span class="error">*{{ $message }}</span>
                        @enderror
                    </div>

                    <div class="col-span-6 sm:col-span-1">
                        <label class="block text-sm font-medium text-gray-700">
                            Monto
                        </label>
                        <input wire:model='total_movement' type="number" step=".01"
                            class="block w-full px-3 py-2 mt-1 capitalize bg-white border-2 border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm">

                        @error('total_movement')
                        <span class="error">*{{ $message }}</span>
                        @enderror
                    </div>

                    <div class="col-span-6 sm:col-span-5">
                        <label class="block text-sm font-medium text-gray-700">
                            Observación <span class="error">*</span>
                        </label>
                        <input wire:model='observation_movement' type="text" maxlength="100"
                            class="block w-full px-3 py-2 mt-1 capitalize bg-white border-2 border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm">
                    </div>

                </div>
            </div>
            <div class="px-4 py-3 text-right bg-gray-50 sm:px-6">

                <button type="submit"
                    class="inline-flex justify-center px-4 py-2 text-sm font-medium text-white bg-indigo-600 border border-transparent rounded-md shadow-sm hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"
                        xmlns="http://www.w3.org/2000/svg">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2zm7-5a2 2 0 11-4 0 2 2 0 014 0z">
                        </path>
                    </svg>
                </button>
            </div>
        </div>
    </form>
</div>

@push('js')
<script>
    $(document).ready(function () {
        $('#select2-dropdown').select2();
        $('#select2-dropdown').on('change', function (e) {
            var data = $('#select2-dropdown').select2("val");
            @this.set('bank_account_id', data);
        });
    });
</script>
@endpush
