<div>
    @livewire('bank.cash-counter')
    {{-- Reporte de bancos --}}
    @if($consult)
    <div class="inline-flex rounded-md shadow-sm" role="group">
        @foreach ($banks as $bank )
        <button type="button"
            class="px-4 py-2 text-sm font-medium text-gray-900 uppercase bg-white border border-gray-200 hover:bg-gray-100 hover:text-blue-700 focus:z-10 focus:ring-2 focus:ring-blue-700 focus:text-blue-700 dark:bg-gray-700 dark:border-gray-600 dark:text-white dark:hover:text-white dark:hover:bg-gray-600 dark:focus:ring-blue-500 dark:focus:text-white">
            {{ $bank->name }}: S/. {{ number_format($bank->total,2) }}
        </button>
        @endforeach

    </div>
    @endif
    <br>
    {{-- Reporte de hoy --}}
    <div class="inline-flex rounded-md shadow-sm" role="group">
        <button type="button"
            class="px-4 py-2 text-sm font-medium text-gray-900 bg-white border border-gray-200 rounded-l-lg hover:bg-gray-100 hover:text-blue-700 focus:z-10 focus:ring-2 focus:ring-blue-700 focus:text-blue-700 dark:bg-gray-700 dark:border-gray-600 dark:text-white dark:hover:text-white dark:hover:bg-gray-600 dark:focus:ring-blue-500 dark:focus:text-white">
            Movimientos: S/. {{ number_format($movement,2) }}
        </button>
        <button type="button"
            class="px-4 py-2 text-sm font-medium text-gray-900 bg-white border-t border-b border-gray-200 hover:bg-gray-100 hover:text-blue-700 focus:z-10 focus:ring-2 focus:ring-blue-700 focus:text-blue-700 dark:bg-gray-700 dark:border-gray-600 dark:text-white dark:hover:text-white dark:hover:bg-gray-600 dark:focus:ring-blue-500 dark:focus:text-white">
            Ventas: S/. {{ number_format($sale,2) }}
        </button>
        <button type="button"
            class="px-4 py-2 text-sm font-medium text-gray-900 bg-white border border-gray-200 hover:bg-gray-100 hover:text-blue-700 focus:z-10 focus:ring-2 focus:ring-blue-700 focus:text-blue-700 dark:bg-gray-700 dark:border-gray-600 dark:text-white dark:hover:text-white dark:hover:bg-gray-600 dark:focus:ring-blue-500 dark:focus:text-white">
            Adelantos: S/. {{ number_format($advance,2) }}
        </button>
        <button type="button"
            class="px-4 py-2 text-sm font-medium text-gray-900 bg-white border border-gray-200 rounded-r-md hover:bg-gray-100 hover:text-blue-700 focus:z-10 focus:ring-2 focus:ring-blue-700 focus:text-blue-700 dark:bg-gray-700 dark:border-gray-600 dark:text-white dark:hover:text-white dark:hover:bg-gray-600 dark:focus:ring-blue-500 dark:focus:text-white">
            Total: S/. {{ number_format($sale + $movement + $advance,2) }}
        </button>
    </div>

    {{-- Botones --}}
    <div class="border-b border-gray-200 dark:border-gray-700">
        <ul class="flex flex-wrap -mb-px text-sm font-medium text-center text-gray-500 dark:text-gray-400">
            <li class="mr-2">
                <label for="movement"
                    class="inline-flex p-4 text-blue-600 border-b-2 border-blue-600 rounded-t-lg cursor-pointer active dark:text-blue-500 dark:border-blue-500 group"
                    aria-current="page">
                    <svg class="w-6 h-6 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24"
                        xmlns="http://www.w3.org/2000/svg">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M7 16V4m0 0L3 8m4-4l4 4m6 0v12m0 0l4-4m-4 4l-4-4"></path>
                    </svg>
                    Movimientos
                </label>
            </li>
            <li class="mr-2">
                <label for="record"
                    class="inline-flex p-4 text-blue-600 border-b-2 border-blue-600 rounded-t-lg cursor-pointer active dark:text-blue-500 dark:border-blue-500 group"
                    aria-current="page">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"
                        xmlns="http://www.w3.org/2000/svg">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-3 7h3m-3 4h3m-6-4h.01M9 16h.01">
                        </path>
                    </svg>
                    Historial
                </label>
            </li>
            <li class="mr-2">
                <a wire:click='getCallTotal'
                    class="inline-flex p-4 text-blue-600 border-b-2 border-blue-600 rounded-t-lg cursor-pointer active dark:text-blue-500 dark:border-blue-500 group"
                    aria-current="page">
                    <svg class="w-6 h-6 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"
                        xmlns="http://www.w3.org/2000/svg">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M9 19l3 3m0 0l3-3m-3 3V10">
                        </path>
                    </svg>
                    Consultar
                </a>
            </li>
            <li class="mr-2">
                <a wire:click='save'
                    class="inline-flex p-4 text-blue-600 border-b-2 border-blue-600 rounded-t-lg cursor-pointer active dark:text-blue-500 dark:border-blue-500 group"
                    aria-current="page">
                    <svg class="w-6 h-6 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"
                        xmlns="http://www.w3.org/2000/svg">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M9 10a1 1 0 011-1h4a1 1 0 011 1v4a1 1 0 01-1 1h-4a1 1 0 01-1-1v-4z"></path>
                    </svg>
                    Grabar
                </a>
            </li>
        </ul>
    </div>

    @livewire('box.today-movement', ['date'=> $date])

    @livewire('box.today-sale', ['date'=> $date])

    @livewire('box.today-advance', ['date'=> $date])

    @livewire('box.today-product', ['date'=> $date])

    @livewire('box.today-service', ['date'=> $date])

    {{-- Modal Movimientos --}}
    <input type="checkbox" id="movement" class="modal-toggle" />
    <div class="modal">
        <div class="w-11/12 max-w-5xl modal-box">
            <label for="movement" class="absolute btn btn-sm btn-circle right-2 top-2">✕</label>
            <div class="hidden sm:block" aria-hidden="true">
                <div class="py-5">
                    <div class="border-t border-gray-200"></div>
                </div>
            </div>
            @livewire('box.movement-box')
            <div class="hidden sm:block" aria-hidden="true">
                <div class="py-5">
                    <div class="border-t border-gray-200"></div>
                </div>
            </div>
        </div>
    </div>

    {{-- Modal Record --}}
    <input type="checkbox" id="record" class="modal-toggle" />
    <div class="modal">
        <div class="w-11/12 max-w-5xl modal-box">
            <label for="record" class="absolute btn btn-sm btn-circle right-2 top-2">✕</label>
            <div class="hidden sm:block" aria-hidden="true">
                <div class="py-5">
                    <div class="border-t border-gray-200"></div>
                </div>
            </div>
            @livewire('box.record-box')
            <div class="hidden sm:block" aria-hidden="true">
                <div class="py-5">
                    <div class="border-t border-gray-200"></div>
                </div>
            </div>
        </div>
    </div>
</div>
