<div>
    @livewire('bank.cash-counter')
    <div class="border-b border-gray-200 dark:border-gray-700">
        <ul class="flex flex-wrap -mb-px text-sm font-medium text-center text-gray-500 dark:text-gray-400">
            <li class="mr-2">
                <label type="button" for="create"
                    class="inline-flex p-4 border-b-2 border-transparent rounded-t-lg cursor-pointer hover:text-gray-600 hover:border-gray-300 dark:hover:text-gray-300 group">
                    <svg class="w-6 h-6 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"
                        xmlns="http://www.w3.org/2000/svg">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M9 13h6m-3-3v6m-9 1V7a2 2 0 012-2h6l2 2h6a2 2 0 012 2v8a2 2 0 01-2 2H5a2 2 0 01-2-2z">
                        </path>
                    </svg>
                    Agregar
                </label>
            </li>
            <li class="mr-2">
                <a href="#"
                    class="inline-flex p-4 text-blue-600 border-b-2 border-blue-600 rounded-t-lg active dark:text-blue-500 dark:border-blue-500 group"
                    aria-current="page">
                    <svg aria-hidden="true" class="w-5 h-5 mr-2 text-blue-600 dark:text-blue-500" fill="currentColor"
                        viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                        <path
                            d="M5 3a2 2 0 00-2 2v2a2 2 0 002 2h2a2 2 0 002-2V5a2 2 0 00-2-2H5zM5 11a2 2 0 00-2 2v2a2 2 0 002 2h2a2 2 0 002-2v-2a2 2 0 00-2-2H5zM11 5a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2V5zM11 13a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2v-2z">
                        </path>
                    </svg>Cuentas
                </a>
            </li>
            <li class="mr-2">
                <a wire:click='updateCash'
                    class="inline-flex p-4 text-blue-600 border-b-2 border-blue-600 rounded-t-lg cursor-pointer active dark:text-blue-500 dark:border-blue-500 group"
                    aria-current="page">
                    <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"
                        xmlns="http://www.w3.org/2000/svg">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z">
                        </path>
                    </svg>Actualizar
                </a>
            </li>
        </ul>
    </div>

    <div class="grid grid-cols-1 sm:grid-cols-3 sm:gap-4">

        @foreach ($banks as $bank)
        <div
            class="w-full p-4 text-center bg-white border rounded-lg shadow-md sm:p-8 dark:bg-gray-800 dark:border-gray-700">
            <h5 class="mb-2 text-3xl font-bold text-gray-900 uppercase dark:text-white">
                {{ $bank->name }}
            </h5>
            <p class="mb-5 text-base text-gray-500 sm:text-lg dark:text-gray-400">
                @if($bank->total > 0)
                <label class="text-2xl font-bold text-green-700">TOTAL: S/. {{ number_format($bank->total,2) }}
                </label>

                @else
                <label class="text-2xl font-bold text-red-700">TOTAL: S/. {{ number_format($bank->total,2) }}
                </label>
                @endif
            </p>



            <div class="items-center justify-center space-y-4 sm:flex sm:space-y-0 sm:space-x-4">
                @if($bank->open == '1')
                <button wire:click="change({{ $bank }})"
                    class="w-full sm:w-auto bg-indigo-800 hover:bg-indigo-700 focus:ring-4 focus:outline-none focus:ring-indigo-300 text-white rounded-lg inline-flex items-center justify-center px-4 py-2.5 dark:bg-indigo-700 dark:hover:bg-indigo-600 dark:focus:ring-indigo-700">
                    <svg class="w-6 h-6 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24"
                        xmlns="http://www.w3.org/2000/svg">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M8 11V7a4 4 0 118 0m-4 8v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2z">
                        </path>
                    </svg>
                    <div class="text-left">
                        ABIERTO
                    </div>
                </button>
                @else
                <button wire:click="change({{ $bank }})"
                    class="w-full sm:w-auto bg-rose-800 hover:bg-rose-700 focus:ring-4 focus:outline-none focus:ring-rose-300 text-white rounded-lg inline-flex items-center justify-center px-4 py-2.5 dark:bg-rose-700 dark:hover:bg-rose-600 dark:focus:ring-rose-700">
                    <svg class="w-6 h-6 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24"
                        xmlns="http://www.w3.org/2000/svg">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z">
                        </path>
                    </svg>
                    <div class="text-left">
                        CERRADO
                    </div>
                </button>
                @endif
                <label for="edit" wire:click="$set('bank_edit',{{ $bank->id }})"
                    class="cursor-pointer w-full sm:w-auto bg-green-800 hover:bg-green-700 focus:ring-4 focus:outline-none focus:ring-green-300 text-white rounded-lg inline-flex items-center justify-center px-4 py-2.5 dark:bg-green-700 dark:hover:bg-green-600 dark:focus:ring-green-700">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"
                        xmlns="http://www.w3.org/2000/svg">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z">
                        </path>
                    </svg>
                    <div class="text-left">
                        EDITAR
                    </div>
                </label>
            </div>
        </div>
        @endforeach

    </div>


    {{-- Modal Create --}}
    <input type="checkbox" id="create" class="modal-toggle" />
    <div class="modal">
        <div class="w-11/12 max-w-5xl modal-box">
            <label for="create" class="absolute btn btn-sm btn-circle right-2 top-2">✕</label>
            <div class="hidden sm:block" aria-hidden="true">
                <div class="py-5">
                    <div class="border-t border-gray-200"></div>
                </div>
            </div>
            @livewire('bank.create-bank')
            <div class="hidden sm:block" aria-hidden="true">
                <div class="py-5">
                    <div class="border-t border-gray-200"></div>
                </div>
            </div>
        </div>
    </div>

    {{-- Modal Editar --}}
    <input type="checkbox" id="edit" class="modal-toggle" />
    <div class="modal">
        <div class="w-11/12 max-w-5xl modal-box">
            <label for="edit" wire:click="$set('bank_edit',null)"
                class="absolute btn btn-sm btn-circle right-2 top-2">✕</label>
            <div class="hidden sm:block" aria-hidden="true">
                <div class="py-5">
                    <div class="border-t border-gray-200"></div>
                </div>
            </div>
            @if($bank_edit)
            @livewire('bank.edit-bank', ['bank'=>$bank_edit])
            @else
            @include('components.load')
            @endif
            <div class="hidden sm:block" aria-hidden="true">
                <div class="py-5">
                    <div class="border-t border-gray-200"></div>
                </div>
            </div>
        </div>
    </div>
</div>
