<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>{{ ucwords($car->Client->names) }} - {{ $sale->id }}</title>
    {{-- @vite(['resources/css/app.css','resources/css/form.css','resources/css/pdf.css','resources/css/font.css'
    ,'resources/js/app.js']) --}}
    <link rel="stylesheet" type="text/css" href="/build/assets/app.527de14e.css">
    <link rel="stylesheet" type="text/css" href="/build/assets/font.49f72275.css">
    <link rel="stylesheet" type="text/css" href="/build/assets/form.176a8e1e.css">
    <link rel="stylesheet" type="text/css" href="/build/assets/pdf.b3bfb073.css">
    <script src="/build/assets/app.9301031d.js"></script>
</head>

<body class="relative h-screen text-xs font ">


    {{-- Modelo de Venta --}}
    <div id="bolet" class="text-xs select-none font">

        {{-- Header --}}
        <div class="grid grid-cols-12 ">
            <div class="col-span-2 text-center ">
                <img class="w-24 h-24" src="{{ asset('img/logo.png') }}" alt="">
            </div>
            <div class="col-span-10 pr-2 text-right">
                <div>
                    <label class="text-2xl font-bold">ORDEN DE REPARACIÓN</label> <br>
                    <label class="text-xl font-bold text-black">
                        N° {{ str_pad($sale->id, 6, '0', STR_PAD_LEFT) }}
                    </label>
                </div>
                <p class="text-xs text-left">
                    Servicio de reparación y mantenimiento en general de gasolinera y diesel, maquinarias pesadas,
                    electricidad
                    y electrónica
                    soldadura autógena y eléctrica venta de repuestos y lubricantes en todas marcas, venta de
                    filtros
                    nacionales
                    e importados. <br>
                    <label class="font-bold">DE: Lido Salazar Córdova</label>
                </p>
            </div>
        </div>
        {{-- Datos del Conductor --}}
        <div class="grid grid-cols-12 mt-3 ">
            <div class="col-span-4 text-center border-t border-l border-r border-black">
                <label class="font-bold text-black">Fecha de Ingreso: </label>
                <label class="font-bold">{{ $sale->created_at->format('d-m-Y') }}</label>
            </div>
            <div class="col-span-4 text-center border-t border-black">

            </div>
            <div class="col-span-4 text-center border-t border-l border-r border-black">
                <label class="font-bold text-black">Fecha de Salida: </label>
                <label class="font-bold">{{ $sale->updated_at->format('d-m-Y') }}</label>
            </div>
            <div class="col-span-12 text-center border border-black">
                <label class="font-bold text-black">DATOS DEL RECEPTOR / CONDUCTOR</label>
            </div>

            <div class="col-span-6 pl-3 border-b border-l border-r border-black">
                <label class="font-bold text-black">Propietario: </label>
                <label class="font-bold capitalize">{{ $car->Client->names }}</label>
            </div>

            <div class="col-span-6 pl-3 border-b border-r border-black">
                <label class="font-bold text-black">Conductor: </label>
                <label class="font-bold capitalize">{{ $client->names }}</label>
            </div>

            <div class="col-span-6 pl-3 uppercase border-b border-l border-r border-black">
                <label class="font-bold text-black">R.U.C: </label>
                <label class="font-bold">{{ $car->Client->ruc }}</label>
            </div>

            <div class="col-span-6 pl-3 uppercase border-b border-r border-black">
                <label class="font-bold text-black">D.N.I: </label>
                <label class="font-bold">{{ $client->dni }}</label>
            </div>

            <div class="col-span-6 pl-3 border-b border-l border-r border-black">
                <label class="font-bold text-black">Teléfono: </label>
                <label class="font-bold uppercase">{{ $car->Client->phone }}</label>
            </div>

            <div class="col-span-6 pl-3 border-b border-r border-black">
                <label class="font-bold text-black">Celular: </label>
                <label class="font-bold uppercase">{{ $client->phone }}</label>
            </div>

            <div class="col-span-12 pl-3 border-b border-l border-r border-black">
                <label class="font-bold text-black">Dirección: </label>
                <label class="font-bold capitalize">{{ $car->Client->address }}</label>
            </div>



        </div>

        {{-- Datos del Vehículo --}}
        <div class="grid grid-cols-12 mt-3">
            <div class="col-span-12 text-center border border-black">
                <label class="font-bold text-black">
                    DATOS DEL VEHÍCULO
                </label>
            </div>

            <div class="col-span-4 pl-3 border-b border-l border-r border-black">
                <label class="font-bold text-black">Placa: </label>
                <label class="font-bold uppercase">{{ $car->plate }}</label>
            </div>

            <div class="col-span-4 pl-3 border-b border-r border-black">
                <label class="font-bold text-black">N° Motor: </label>
                <label class="font-bold uppercase">{{ $car->engine }}</label>
            </div>
            <div class="col-span-4 pl-3 border-b border-r border-black">
                <label class="font-bold text-black">N° Chasis: </label>
                <label class="font-bold uppercase">{{ $car->chassis }}</label>
            </div>

            <div class="col-span-4 pl-3 border-b border-l border-r border-black">
                <label class="font-bold text-black">Marca: </label>
                <label class="font-bold capitalize">{{ $car->brand }}</label>
            </div>

            <div class="col-span-4 pl-3 border-b border-r border-black">
                <label class="font-bold text-black">Modelo: </label>
                <label class="font-bold capitalize">{{ $car->model }}</label>
            </div>
            <div class="col-span-4 pl-3 border-b border-r border-black">
                <label class="font-bold text-black">Año: </label>
                <label class="font-bold uppercase">{{ $car->year }}</label>
            </div>

            <div class="col-span-4 pl-3 border-b border-l border-r border-black">
                <label class="font-bold text-black">Color: </label>
                <label class="font-bold capitalize">{{ $car->color }}</label>
            </div>

            <div class="col-span-4 pl-3 border-b border-r border-black">
            </div>
            <div class="col-span-4 pl-3 border-b border-r border-black">
                <label class="font-bold text-black">KM: </label>
                <label class="font-bold capitalize">{{ $sale->km }}</label>
            </div>
        </div>

        {{-- Productos --}}
        @if (count($products))
            <div class="grid grid-cols-12 mt-3">
                <div class="col-span-12 text-center border border-black">
                    <label class="font-bold text-black">
                        PRODUCTOS AGREGADOS
                    </label>
                </div>

                <div class="col-span-1 pl-3 text-center border-b border-l border-r border-black">
                    <label class="font-bold text-black">CANT</label>
                </div>

                <div class="col-span-7 pl-3 border-b border-r border-black">
                    <label class="font-bold text-black">DESCRIPCIÓN</label>
                </div>
                <div class="col-span-2 pl-3 text-center border-b border-r border-black">
                    <label class="font-bold text-black">P. UNIT</label>
                </div>

                <div class="col-span-2 pl-3 text-center border-b border-r border-black">
                    <label class="font-bold text-black">TOTAL</label>
                </div>

                @foreach ($products as $product)
                    <div class="col-span-1 pl-3 text-center border-b border-l border-r border-black">
                        <label class="font-bold uppercase">{{ $product->amount_product_sale }}</label>
                    </div>

                    <div class="col-span-7 pl-3 border-b border-r border-black">
                        <label class="font-bold capitalize">{{ $product->description_product_bolet }}</label>
                    </div>
                    <div class="col-span-2 pl-3 text-center border-b border-r border-black">
                        <label
                            class="font-bold uppercase">S/.{{ number_format($product->price_product_sale, 2) }}</label>
                    </div>

                    <div class="col-span-2 pl-3 text-center border-b border-r border-black">
                        <label
                            class="font-bold capitalize">S/.{{ number_format($product->amount_product_sale * $product->price_product_sale, 2) }}</label>

                        <div class="hidden">
                            {{ $total_products += $product->price_product_sale * $product->amount_product_sale }}
                        </div>
                    </div>
                @endforeach
                <div class="col-span-10 pr-3 text-right border-b border-l border-r border-black">
                    <label class="font-bold text-black capitalize">TOTAL PRODUCTOS: </label>
                </div>
                <div class="col-span-2 pl-3 text-center border-b border-r border-black">
                    <label class="font-bold capitalize">S/.{{ number_format($total_products, 2) }}</label>
                </div>
            </div>
        @endif

        {{-- Servicios --}}
        @if (count($services))
            <div class="grid grid-cols-12 mt-3">
                <div class="col-span-12 text-center border border-black">
                    <label class="font-bold text-black">
                        SERVICIOS PRESTADOS
                    </label>
                </div>

                <div class="col-span-10 pl-3 border-b border-l border-r border-black">
                    <label class="font-bold text-black">
                        DESCRIPCIÓN
                    </label>
                </div>

                <div class="col-span-2 pl-3 text-center border-b border-r border-black">
                    <label class="font-bold text-black">PRECIO</label>
                </div>

                @foreach ($services as $service)
                    <div class="col-span-10 pl-3 border-b border-l border-r border-black">
                        <label class="font-bold capitalize">
                            {{ $service->description_service }}
                        </label>
                    </div>

                    <div class="col-span-2 pl-3 text-center border-b border-r border-black">
                        <label class="font-bold ">
                            S/.{{ number_format($service->price_sale_service, 2) }}
                        </label>
                        <div class="hidden">
                            {{ $total_services += $service->price_sale_service }}
                        </div>
                    </div>
                @endforeach

                <div class="col-span-10 pr-3 text-right border-b border-l border-r border-black">
                    <label class="font-bold text-black ">
                        TOTAL SERVICIOS:
                    </label>
                </div>

                <div class="col-span-2 pl-3 text-center border-b border-r border-black">
                    <label class="font-bold ">
                        S/.{{ number_format($total_services, 2) }}
                    </label>
                </div>
            </div>
        @endif

        {{-- Adelantos --}}
        @if (count($advances))
            <div class="grid grid-cols-12 mt-3">
                <div class="col-span-12 text-center border border-black">
                    <label class="font-bold text-black">
                        ADELANTOS
                    </label>
                </div>

                <div class="col-span-4 pl-3 text-center border-b border-l border-r border-black">
                    <label class="font-bold text-black">
                        M. PAGO
                    </label>
                </div>

                <div class="col-span-4 pl-3 text-center border-b border-r border-black">
                    <label class="font-bold text-black">
                        FECHA - HORA
                    </label>
                </div>

                <div class="col-span-4 pl-3 text-center border-b border-r border-black">
                    <label class="font-bold text-black">
                        MONTO
                    </label>
                </div>

                @foreach ($advances as $advance)
                    <div class="col-span-4 pl-3 text-center border-b border-l border-r border-black">
                        <label class="font-bold capitalize">
                            {{ $advance->BankAccount->description }}
                        </label>
                    </div>
                    <div class="col-span-4 pl-3 text-center border-b border-l border-r border-black">
                        <label class="font-bold capitalize">
                            {{ $advance->created_at }}
                        </label>
                    </div>

                    <div class="col-span-4 pl-3 text-center border-b border-r border-black">
                        <label class="font-bold ">
                            S/.{{ number_format($advance->total_advance, 2) }}
                        </label>
                    </div>
                @endforeach

                <div class="col-span-8 pr-3 text-right border-b border-l border-r border-black">
                    <label class="font-bold text-black ">
                        TOTAL SERVICIOS:
                    </label>
                </div>

                <div class="col-span-4 pl-3 text-center border-b border-r border-black">
                    <label class="font-bold ">
                        S/.{{ number_format($total_advances, 2) }}
                    </label>
                </div>
            </div>
        @endif
        {{-- Total a Pagar --}}
        @if ($total_sale != 0 && $sale->total_discount_sale != 0)
            <div class="grid grid-cols-10 mt-3">
                <div class="col-span-2 text-center border-t border-l border-black">
                    <label class="font-bold text-black">
                        TOTAL PRODUCTOS
                    </label>
                </div>
                <div class="col-span-2 text-center border-t border-l border-black">
                    <label class="font-bold text-black">
                        TOTAL SERVICIOS
                    </label>
                </div>
                <div class="col-span-2 text-center border-t border-l border-black">
                    <label class="font-bold text-black">
                        TOTAL ADELANTOS
                    </label>
                </div>
                <div class="col-span-2 text-center border-t border-l border-black">
                    <label class="font-bold text-black">
                        TOTAL DESCUENTO
                    </label>
                </div>
                <div class="col-span-2 text-center border-t border-l border-r border-black">
                    <label class="font-bold text-black">
                        TOTAL A PAGAR
                    </label>
                </div>

                <div class="col-span-2 text-center border-t border-b border-l border-black">
                    <label class="font-bold ">
                        S/.{{ number_format($total_products, 2) }}
                    </label>
                </div>
                <div class="col-span-2 text-center border-t border-b border-l border-black">
                    <label class="font-bold">
                        S/.{{ number_format($total_services, 2) }}
                    </label>
                </div>
                <div class="col-span-2 text-center border-t border-b border-l border-black">
                    <label class="font-bold ">
                        S/.{{ number_format($total_advances, 2) }}
                    </label>
                </div>
                <div class="col-span-2 text-center border-t border-b border-l border-black">
                    <label class="font-bold text-black ">
                        - S/.{{ number_format($sale->total_discount_sale, 2) }}
                    </label>
                </div>
                <div class="col-span-2 text-center border-t border-b border-l border-r border-black">
                    <label class="font-bold text-black">
                        S/.{{ number_format($total_sale, 2) }}
                    </label>
                </div>
            </div>
        @endif
        @if ($total_sale != 0 && $sale->total_discount_sale == 0)
            <div class="grid grid-cols-12 mt-3">
                <div class="col-span-3 text-center border-t border-l border-black">
                    <label class="font-bold text-black">
                        TOTAL PRODUCTOS
                    </label>
                </div>
                <div class="col-span-3 text-center border-t border-l border-black">
                    <label class="font-bold text-black">
                        TOTAL SERVICIOS
                    </label>
                </div>
                <div class="col-span-3 text-center border-t border-l border-black">
                    <label class="font-bold text-black">
                        TOTAL ADELANTOS
                    </label>
                </div>
                <div class="col-span-3 text-center border-t border-l border-r border-black">
                    <label class="font-bold text-black">
                        TOTAL A PAGAR
                    </label>
                </div>

                <div class="col-span-3 text-center border-t border-b border-l border-black">
                    <label class="font-bold ">
                        S/.{{ number_format($total_products, 2) }}
                    </label>
                </div>
                <div class="col-span-3 text-center border-t border-b border-l border-black">
                    <label class="font-bold">
                        S/.{{ number_format($total_services, 2) }}
                    </label>
                </div>
                <div class="col-span-3 text-center border-t border-b border-l border-black">
                    <label class="font-bold ">
                        S/.{{ number_format($total_advances, 2) }}
                    </label>
                </div>
                <div class="col-span-3 text-center border-t border-b border-l border-r border-black">
                    <label class="font-bold text-black">
                        S/.{{ number_format($total_sale, 2) }}
                    </label>
                </div>
            </div>
        @endif

        {{-- Observaciones --}}
        @if ($sale->observation_sale)
            <div class="grid grid-cols-12 mt-3">
                <div class="col-span-12 p-2 border border-black">
                    <label class="firts">Observaciones: </label>
                    <label>{{ $sale->observation_sale }}</label>

                </div>
            </div>
        @endif
    </div>


    {{-- Firmas --}}
    <div class="absolute inset-x-0 bottom-0 w-full">
        <div class="grid grid-cols-12 mt-12 text-xs font-bold ">
            <div class="col-span-1">
            </div>
            <div class="col-span-4 text-center">
                _______________________________ <br>
                ADMINISTRADOR
            </div>
            <div class="col-span-2">
            </div>
            <div class="col-span-4 text-center capitalize">
                _______________________________ <br>
                CLIENTE: {{ $car->Client->names }} <br>
                DNI: {{ $car->Client->dni }}
            </div>
            <div class="col-span-1">
            </div>
        </div>

        <div class="grid grid-cols-12 mt-6 ">
            <div class="col-span-6 text-left">
                <div class="grid grid-cols-6 font-bold">
                    <div class="col-span-6 text-center border-t border-l border-r border-black">
                        <label>
                            Cuentas Lisac Motors
                        </label>
                    </div>
                    <div class="col-span-6 pl-3 border-t border-l border-r border-black">
                        <label>
                            BANCO DE LA NACION: 04-195-308603
                        </label>
                    </div>
                    <div class="col-span-6 pl-3 border-t border-l border-r border-black">
                        <label>
                            CUENTA BCP: 20591954286001
                        </label>
                    </div>
                    <div class="col-span-6 pl-3 border-t border-b border-l border-r border-black">
                        <label>
                            BBVA: 0011-0814-0209695338
                        </label>
                    </div>
                </div>
            </div>
            <div class="col-span-6 font-bold text-right">
                Teléfonos: # 901-278-101 <br>
                Jr Ricardo Palma S/N, Talavera. <br>
                Al frente del estadio de talavera.
            </div>
        </div>
    </div>


</body>



</html>
