<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>{{ ucwords($calculate->property_calculate) }}</title>
    {{-- @vite(['resources/css/app.css','resources/css/form.css','resources/css/pdf.css','resources/css/font.css'
    ,'resources/js/app.js']) --}}
    <link rel="stylesheet" type="text/css" href="/build/assets/app.527de14e.css">
    <link rel="stylesheet" type="text/css" href="/build/assets/font.49f72275.css">
    <link rel="stylesheet" type="text/css" href="/build/assets/form.176a8e1e.css">
    <link rel="stylesheet" type="text/css" href="/build/assets/pdf.b3bfb073.css">
    <script src="/build/assets/app.9301031d.js"></script>
</head>

<body>
    <div>
        <div class="text-xs font">
            {{-- Header --}}
            <div class="grid grid-cols-12 ">
                <div class="col-span-2 text-center ">
                    <img class="w-24 h-24" src="{{ asset('img/logo.png') }}" alt="">
                </div>
                <div class="col-span-10 pr-2 text-right">
                    <div>
                        <label class="text-2xl font-bold">COTIZACIÓN</label> <br>
                        <label class="text-xl font-bold text-red-600">
                            N° {{ str_pad($calculate->id, 6, '0', STR_PAD_LEFT) }}
                        </label>
                    </div>
                    <p class="text-xs text-left">
                        Servicio de reparación y mantenimiento en general de gasolinera y diesel, maquinarias pesadas,
                        electricidad
                        y electrónica
                        soldadura autógena y eléctrica venta de repuestos y lubricantes en todas marcas, venta de
                        filtros
                        nacionales
                        e importados. <br>
                        <label class="font-bold">DE: Lido Salazar Córdova</label>
                    </p>
                </div>
            </div>
            {{-- Datos del Conductor --}}
            <div class="grid grid-cols-12 mt-3">
                <div class="col-span-4 text-center border-t border-l border-r border-indigo-600">
                    <label class="font-bold text-blue-600">Fecha de Ingreso: </label>
                    <label class="font-bold">{{ $calculate->created_at->format('d-m-Y') }}</label>
                </div>
                <div class="col-span-4 text-center border-t border-indigo-600">

                </div>
                <div class="col-span-4 text-center border-t border-l border-r border-indigo-600">
                    <label class="font-bold text-blue-600">Fecha de Salida: </label>
                    <label class="font-bold">{{ $calculate->updated_at->format('d-m-Y') }}</label>
                </div>
                <div class="col-span-12 text-center border border-indigo-600">
                    <label class="font-bold text-blue-600">DATOS DEL RECEPTOR / CONDUCTOR</label>
                </div>

                <div class="col-span-6 pl-3 border-b border-l border-r border-indigo-600">
                    <label class="font-bold text-blue-600">Propietario: </label>
                    <label class="font-bold capitalize">{{ $calculate->property_calculate }}</label>
                </div>

                <div class="col-span-6 pl-3 border-b border-r border-indigo-600">
                    <label class="font-bold text-blue-600">Conductor: </label>
                    <label class="font-bold capitalize">{{ $calculate->driver_calculate }}</label>
                </div>

                <div class="col-span-6 pl-3 uppercase border-b border-l border-r border-indigo-600">
                    <label class="font-bold text-blue-600">R.U.C: </label>
                    <label class="font-bold">{{ $calculate->ruc_calculate }}</label>
                </div>

                <div class="col-span-6 pl-3 uppercase border-b border-r border-indigo-600">
                    <label class="font-bold text-blue-600">D.N.I: </label>
                    <label class="font-bold">{{ $calculate->dni_calculate }}</label>
                </div>

                <div class="col-span-4 pl-3 border-b border-l border-r border-indigo-600">
                    <label class="font-bold text-blue-600">Teléfono: </label>
                    <label class="font-bold uppercase">{{ $calculate->phone_calculate }}</label>
                </div>
                <div class="col-span-4 pl-3 border-b border-l border-r border-indigo-600">
                    @if ($calculate->celp_calculate)
                        <label class="font-bold text-blue-600">Celular: </label>
                        <label class="font-bold uppercase">{{ $calculate->celp_calculate }}</label>
                    @endif
                </div>

                <div class="col-span-4 pl-3 border-b border-r border-indigo-600">
                    <label class="font-bold text-blue-600">Celular: </label>
                    <label class="font-bold uppercase">{{ $calculate->celd_calculate }}</label>
                </div>

                <div class="col-span-12 pl-3 border-b border-l border-r border-indigo-600">
                    <label class="font-bold text-blue-600">Dirección: </label>
                    <label class="font-bold capitalize">{{ $calculate->address_calculate }}</label>
                </div>



            </div>

            {{-- Datos del Vehículo --}}
            <div class="grid grid-cols-12 mt-3">
                <div class="col-span-12 text-center border border-indigo-600">
                    <label class="font-bold text-blue-600">
                        DATOS DEL VEHÍCULO
                    </label>
                </div>

                <div class="col-span-4 pl-3 border-b border-l border-r border-indigo-600">
                    <label class="font-bold text-blue-600">Placa: </label>
                    <label class="font-bold uppercase">{{ $calculate->plate_calculate }}</label>
                </div>

                <div class="col-span-4 pl-3 border-b border-r border-indigo-600">
                    <label class="font-bold text-blue-600">N° Motor: </label>
                    <label class="font-bold uppercase">{{ $calculate->engine_calculate }}</label>
                </div>
                <div class="col-span-4 pl-3 border-b border-r border-indigo-600">
                    <label class="font-bold text-blue-600">N° Chasis: </label>
                    <label class="font-bold uppercase">{{ $calculate->chassis_calculate }}</label>
                </div>

                <div class="col-span-4 pl-3 border-b border-l border-r border-indigo-600">
                    <label class="font-bold text-blue-600">Marca: </label>
                    <label class="font-bold capitalize">{{ $calculate->brand_calculate }}</label>
                </div>

                <div class="col-span-4 pl-3 border-b border-r border-indigo-600">
                    <label class="font-bold text-blue-600">Modelo: </label>
                    <label class="font-bold capitalize">{{ $calculate->model_calculate }}</label>
                </div>
                <div class="col-span-4 pl-3 border-b border-r border-indigo-600">
                    <label class="font-bold text-blue-600">Año: </label>
                    <label class="font-bold uppercase">{{ $calculate->year_car_calculate }}</label>
                </div>

                <div class="col-span-4 pl-3 border-b border-l border-r border-indigo-600">
                    <label class="font-bold text-blue-600">Color: </label>
                    <label class="font-bold capitalize">{{ $calculate->color_calculate }}</label>
                </div>

                <div class="col-span-4 text-center border-b border-r border-indigo-600 ">

                </div>
                <div class="col-span-4 pl-3 border-b border-r border-indigo-600">
                    <label class="font-bold text-blue-600">Recorrido KM: </label>
                    <label class="font-bold capitalize">{{ $calculate->km_calculate }}</label>
                </div>

            </div>

            {{-- Items --}}
            @if (count($items))
                <div class="grid grid-cols-12 mt-3">
                    {{-- <div class="col-span-12 text-center border border-indigo-600">
                    <label class="font-bold text-blue-600">
                        itemOS AGREGADOS
                    </label>
                </div> --}}
                    <div class="col-span-12 text-center border-b border-indigo-600">

                    </div>
                    <div class="col-span-1 pl-3 text-center border-b border-l border-r border-indigo-600">
                        <label class="font-bold text-blue-600">CANT</label>
                    </div>

                    <div class="col-span-4 pl-3 border-b border-r border-indigo-600">
                        <label class="font-bold text-blue-600">DESCRIPCIÓN</label>
                    </div>

                    <div class="col-span-3 pl-3 border-b border-r border-indigo-600">
                        <label class="font-bold text-blue-600">MARCA</label>
                    </div>

                    <div class="col-span-2 pl-3 text-center border-b border-r border-indigo-600">
                        <label class="font-bold text-blue-600">P. UNIT</label>
                    </div>

                    <div class="col-span-2 pl-3 text-center border-b border-r border-indigo-600">
                        <label class="font-bold text-blue-600">TOTAL</label>
                    </div>

                    @foreach ($items as $item)
                        <div class="col-span-1 pl-3 text-center border-b border-l border-r border-indigo-600">
                            <label class="font-bold uppercase">{{ $item->amount_item }}</label>
                        </div>

                        <div class="col-span-4 pl-3 border-b border-r border-indigo-600">
                            <label class="font-bold capitalize">{{ $item->description_item }}</label>
                        </div>

                        <div class="col-span-3 pl-3 border-b border-r border-indigo-600">
                            <label class="font-bold capitalize">{{ $item->brand_item }}</label>
                        </div>

                        <div class="col-span-2 pl-3 text-center border-b border-r border-indigo-600">
                            <label class="font-bold uppercase">S/.{{ number_format($item->price_item, 2) }}</label>
                        </div>

                        <div class="col-span-2 pl-3 text-center border-b border-r border-indigo-600">
                            <label
                                class="font-bold capitalize">S/.{{ number_format($item->amount_item * $item->price_item, 2) }}</label>

                            <div class="hidden">
                                {{ $total_items += $item->amount_item * $item->price_item }}
                            </div>
                        </div>
                    @endforeach
                    <div class="col-span-10 pr-3 text-right border-b border-l border-r border-indigo-600">
                        <label class="font-bold text-indigo-600 capitalize">TOTAL: </label>
                    </div>
                    <div class="col-span-2 pl-3 text-center border-b border-r border-indigo-600">
                        <label
                            class="font-bold capitalize">S/.{{ number_format($total_items, 2) }}</label>
                    </div>
                </div>
            @endif

            {{-- Firmas --}}
            <div class="absolute w-full text-xs bottom-2">
                <div class="grid grid-cols-12 mt-12 text-xs font-bold ">
                    <div class="col-span-1">
                    </div>
                    <div class="relative col-span-4 text-center ">
                        <img class="absolute h-28 left-1/3 -top-14 " src="{{ asset('img/firma.png') }}"
                            alt="">
                        _______________________________ <br>
                        ADMINISTRADOR
                    </div>
                    <div class="col-span-2">
                    </div>
                    <div class="col-span-4 text-center capitalize">
                        _______________________________ <br>
                        CLIENTE: {{ $calculate->property_calculate }} <br>
                        DNI: {{ $calculate->dni_calculate }}
                    </div>
                    <div class="col-span-1">
                    </div>
                </div>

                <div class="grid grid-cols-12 mt-6 ">
                    <div class="col-span-6 text-left">
                        <div class="grid grid-cols-6 font-bold">
                            <div class="col-span-6 text-center border-t border-l border-r border-black">
                                <label>
                                    Cuentas Lisac Motors
                                </label>
                            </div>
                            <div class="col-span-6 pl-3 border-t border-l border-r border-black">
                                <label>
                                    BANCO DE LA NACION: 04-195-308603
                                </label>
                            </div>
                            <div class="col-span-6 pl-3 border-t border-l border-r border-black">
                                <label>
                                    CUENTA BCP: 20591954286001
                                </label>
                            </div>
                            <div class="col-span-6 pl-3 border-t border-b border-l border-r border-black">
                                <label>
                                    BBVA: 0011-0814-0209695338
                                </label>
                            </div>
                        </div>
                    </div>
                    <div class="col-span-6 font-bold text-right">
                        Teléfonos: # 901-278-101 <br>
                        Jr Ricardo Palma S/N, Talavera. <br>
                        Al frente del estadio de talavera.
                    </div>
                </div>
            </div>

        </div>
    </div>

</body>

</html>
