<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>LISAC MOTORS</title>
    <!--Alpine Js-->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/alpinejs/2.3.0/alpine-ie11.min.js"
        integrity="sha512-Atu8sttM7mNNMon28+GHxLdz4Xo2APm1WVHwiLW9gW4bmHpHc/E2IbXrj98SmefTmbqbUTOztKl5PDPiu0LD/A=="
        crossorigin="anonymous"></script>
    <!--Sweet Alert-->
    <script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <!--Select2-->
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <script src="//cdnjs.cloudflare.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <!---->


    <link rel="stylesheet" type="text/css" href="/build/assets/app.527de14e.css">
    <link rel="stylesheet" type="text/css" href="/build/assets/font.49f72275.css">
    <link rel="stylesheet" type="text/css" href="/build/assets/form.176a8e1e.css">
    <link rel="stylesheet" type="text/css" href="/build/assets/pdf.b3bfb073.css">

    {{-- <script src="/build/assets/app.9301031d.js"></script> --}}

    @livewireStyles
</head>

<body class="select-none">

    @if (Auth::user())
        @if (Auth::user()->type == '0')
            @include('nav.nav-mecanic')
        @elseif (Auth::user()->type == '1')
            @include('nav.nav-oficce')
        @else
            @include('nav.nav-admin')
        @endif
    @else
        @include('nav.nav-logout')
    @endif

    <main class="Quicksand">
        <div class="py-6 mx-auto max-w-7xl sm:px-6 lg:px-8">
            <!-- Replace with your content -->
            {{ $slot }}
            <!-- /End replace -->
        </div>
    </main>



    @livewireScripts

    @stack('js')



    <script>
        Livewire.on('notify', (message) => {
            Swal.fire({
                position: 'top-end',
                icon: 'success',
                title: message,
                showConfirmButton: false,
                timer: 1500
            })
        });

        Livewire.on('question', (message) => {
            Swal.fire({
                title: message.title,
                text: message.subtitle,
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Aceptar'
            }).then((result) => {
                if (result.isConfirmed) {
                    if (message.module === 'calculate') {
                        Livewire.emitTo('calculate.index-calculate', 'delete', message.id)
                        Swal.fire(
                            'Cancelado!',
                            'La cotización ha sido cancelada.',
                            'success'
                        )
                    }
                    if (message.module === 'service') {
                        Livewire.emitTo('service.index-service', 'delete', message.id)
                        Swal.fire(
                            'Eliminado!',
                            'El servicio ha sido eliminado.',
                            'success'
                        )
                    }
                    if (message.module === 'product') {
                        Livewire.emitTo('product.index-product', 'delete', message.id)
                        Swal.fire(
                            'Eliminado!',
                            'El producto ha sido eliminado.',
                            'success'
                        )
                    }
                    if (message.module === 'client') {
                        Livewire.emitTo('client.index-client', 'delete', message.id)
                        Swal.fire(
                            'Eliminado!',
                            'El Cliente ha sido eliminado.',
                            'success'
                        )
                    }

                    if (message.module === 'car') {
                        Livewire.emitTo('car.index-car', 'delete', message.id)
                        Swal.fire(
                            'Eliminado!',
                            'El Vehículo del cliente ha sido eliminado.',
                            'success'
                        )
                    }
                    if (message.module === 'cancelsale') {
                        Livewire.emitTo('sale.show-sale', 'cancel')
                        Swal.fire(
                            'Venta Cancelada!',
                            'La venta ha sido cancelada',
                            'success'
                        )
                    }
                    if (message.module === 'paysale') {
                        Livewire.emitTo('sale.show-sale', 'pay')
                        Swal.fire(
                            'Venta Pagada!',
                            'La venta ha sido pagada',
                            'success'
                        )
                    }
                    if (message.module === 'debtsale') {
                        Livewire.emitTo('sale.show-sale', 'debt')
                        Swal.fire(
                            'Venta Pagada!',
                            'La venta ha sido pagada',
                            'success'
                        )
                    }
                    if (message.module === 'user') {
                        Livewire.emitTo('user.index-user', 'delete', message.id)
                        Swal.fire(
                            'Personal Eliminado!',
                            'El personal fue eliminado',
                            'success'
                        )
                    }
                    if (message.module === 'password') {
                        Livewire.emitTo('user.index-user', 'resetpwd', message.id)
                        Swal.fire(
                            'Contraseña Reestablecida!',
                            'La contraseña del Personal fue reestablecida',
                            'success'
                        )
                    }
                    if (message.module === 'box') {
                        Livewire.emitTo('box.index-box', 'cancel', message.id)
                        Swal.fire(
                            'Cancelado!',
                            'success'
                        )
                    }

                }
            })
        })

        Livewire.on('error', (message) => {
            Swal.fire({
                icon: 'error',
                title: message.title,
                text: message.subtitle,
                footer: message.footer
            })
        })
    </script>
</body>

</html>
