<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('item_calculates', function (Blueprint $table) {
            $table->id();
            $table->integer('amount_item');
            $table->string('description_item');
            $table->string('brand_item')->nullable();
            $table->float('price_item');
            $table->unsignedBigInteger('calculate_id');
            $table->timestamps();
            // Foreign key
            $table->foreign('calculate_id')->references('id')->on('calculates');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('item_calculates');
    }
};
