<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sale_service', function (Blueprint $table) {
            $table->id();
            $table->float('price_sale_service'); // Precio del servicio
            $table->unsignedBigInteger('sale_id');
            $table->unsignedBigInteger('service_id');
            $table->timestamps();
            $table
                ->foreign('sale_id')
                ->references('id')
                ->on('sales');
            $table
                ->foreign('service_id')
                ->references('id')
                ->on('services');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sale_service');
    }
};
