<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('debt_reminders', function (Blueprint $table) {
            $table->id();
            $table->string('message', 120)->nullable();
            $table->string('status_remember', 1)->default('0'); // Visto = 1 / No visto = 0
            $table->date('date');
            $table->unsignedBigInteger('sale_id');
            $table->timestamps();
            $table->foreign('sale_id')->references('id')->on('sales');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('debt_reminders');
    }
};
