<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sales', function (Blueprint $table) {
            $table->id();
            $table->float('total_sale')->default(0); // monto total pagado
            $table->float('total_discount_sale')->default(0); // descuento
            $table->string('observation_sale', 100)->nullable(); // observaciones de la venta
            $table->unsignedBigInteger('condition_id')->default(1); // Estado de venta
            $table->unsignedBigInteger('bank_account_id'); // Cuenta a depositar
            $table->string('km', 7)->nullable(); // Kilometraje del vehiculo
            $table->unsignedBigInteger('car_id');
            $table->unsignedBigInteger('client_id');
            $table->timestamps();
            // Foreign Key
            $table->foreign('condition_id')
                ->references('id')
                ->on('conditions');
            $table->foreign('bank_account_id')
                ->references('id')
                ->on('bank_accounts');
            $table
                ->foreign('car_id')
                ->references('id')
                ->on('cars');
            $table
                ->foreign('client_id')
                ->references('id')
                ->on('clients');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sales');
    }
};
