<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id();
            $table->string('description_product', 60)->unique();
            $table->string('description_product_bolet', 60);
            $table->float('buy_product'); // Precio de Compra
            $table->float('sell_product'); // Precio de Venta
            $table->string('status_product', 1)->default('1'); // 0 = inactivo / 1 = activo
            $table->integer('stock_product')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('products');
    }
};
