<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('cars', function (Blueprint $table) {
            $table->id();
            $table->string('plate', 20)->unique();
            $table->string('engine', 20)->nullable();
            $table->string('brand', 20)->nullable();
            $table->string('model', 20)->nullable();
            $table->string('chassis', 20)->nullable();
            $table->string('year', 4)->nullable();
            $table->string('color', 20)->nullable();
            $table->unsignedBigInteger('client_id');
            $table->timestamps();
            $table->foreign('client_id')->references('id')->on('clients');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cars');
    }
};
