<?php

namespace Database\Factories;

use App\Models\BankAccount;
use App\Models\Client;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Movement>
 */
class MovementFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition()
    {
        return [
            'concept' => fake()->text(20),
            'person' => Client::all()->random()->id,
            'total_movement' => fake()->numberBetween(1, 100),
            'observation_movement' => fake()->text(50),
            'bank_account_id' => BankAccount::all()->random()->id
        ];
    }
}
