<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Sale extends Model
{
    use HasFactory;
    protected $fillable = [
        'total_sale', 'total_discount_sale', 'observation_sale', 'condition_id', 'bank_account_id',
        'km', 'car_id', 'client_id'
    ];

    public function Service()
    {
        return $this->belongsToMany(Service::class)->withPivot(
            'price_sale_service',
        )->withTimestamps();
    }

    public function Product()
    {
        return $this->belongsToMany(Product::class)->withPivot(
            'price_product_sale',
            'amount_product_sale',
            'price_product_buy'
        )->withTimestamps();
    }

    public function BankAccount()
    {
        return $this->belongsTo(BankAccount::class);
    }

    public function Client()
    {
        return $this->belongsTo(Client::class);
    }

    public function Car()
    {
        return $this->belongsTo(Car::class);
    }

    public function Condition()
    {
        return $this->belongsTo(Condition::class);
    }

    public function Notification()
    {
        return $this->hasMany(Notification::class);
    }

    public function Order()
    {
        return $this->hasMany(Order::class);
    }

    public function Report()
    {
        return $this->hasMany(Report::class);
    }

    public function Advance()
    {
        return $this->hasMany(Advance::class);
    }

    public function DebtReminder()
    {
        return $this->hasMany(DebtReminder::class);
    }
}
