<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Product extends Model
{
    use HasFactory;
    protected $fillable = [
        'description_product', 'description_product_bolet', 'status_product',
        'buy_product', 'sell_product', 'stock_product'
    ];
    public function Sale()
    {
        return $this->belongsToMany(Sale::class)->withPivot(
            'price_product_sale',
            'amount_product_sale',
            'price_product_buy'
        )->withTimestamps();
    }
}
