<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BankAccount extends Model
{
    use HasFactory;
    protected $fillable = ['name', 'total', 'sum', 'open'];

    public function Movement()
    {
        return $this->hasMany(Movement::class);
    }


    public function Advance()
    {
        return $this->hasMany(Advance::class);
    }

    public function Sale()
    {
        return $this->hasMany(Sale::class);
    }
}
