<?php

namespace App\Http\Livewire\User;

use App\Models\User;
use Illuminate\Support\Facades\Hash;
use Livewire\Component;

class IndexUser extends Component
{
    public $user;
    protected $listeners = ['render', 'delete', 'resetpwd'];
    public function render()
    {
        $users = User::where('type', '!=', '3')->get();
        return view('livewire.user.index-user', compact('users'))
            ->layout('app');
    }

    // Preguntar Eliminar
    public function question($item)
    {
        $this->emit('question', [
            'title' => 'Eliminar al Personal' . ' ' . ucwords($item['name']),
            'subtitle' => 'Se eliminará permanentemente', 'module' => 'user',
            'id' => $item['id']
        ]);
    }

    // Eliminar
    public function delete(User $user)
    {
        $user->delete();
    }

    // Preguntar Reestablecer Contraseña
    public function questionReset($item)
    {
        $this->emit('question', [
            'title' => 'Reestablecer contraseña de' . ' ' . ucwords($item['name']),
            'subtitle' => 'Se reestablecerá su contraseña', 'module' => 'password',
            'id' => $item['id']
        ]);
    }

    // Reestablecer
    public function resetpwd(User $user)
    {
        $user->update([
            'password' => Hash::make($user->email)
        ]);
    }
}
