<?php

namespace App\Http\Livewire\User;

use App\Models\User;
use Illuminate\Support\Facades\Hash;
use Livewire\Component;
use Illuminate\Support\Str;

class CreateUser extends Component
{
    public $name, $email,  $type = '1';
    protected $rules = [
        'email' => 'required|unique:users,email',
        'name' => 'required'
    ];

    public function updated($propertyName)
    {
        $this->validateOnly($propertyName);
    }

    protected $messages = [
        'email.required' => 'El nombre de usuario es obligatorio',
        'email.unique' => 'El nombre de usuario ya existe',
        'name.required' => 'El nombre completo del personal es obligatiorio'
    ];
    public function render()
    {
        return view('livewire.user.create-user');
    }

    public function save()
    {
        $this->name = Str::lower($this->name);
        $this->validate();
        User::create([
            'name' => Str::lower($this->name),
            'email' => $this->email,
            'password' => Hash::make($this->email),
            'type' => $this->type
        ]);
        $this->reset([
            'name',
            'email',
            'type'
        ]);
        $this->emitTo('user.index-user', 'render');
        $this->emit('notify', 'Personal Agregado');
    }
}
