<?php

namespace App\Http\Livewire\Service;

use App\Models\Service;
use Livewire\Component;
use Livewire\WithPagination;
use Illuminate\Support\Str;

class IndexService extends Component
{
    use WithPagination;
    public $search = '', $service;

    protected $listeners = ['delete', 'render'];

    public function updatingSearch()
    {
        $this->resetPage();
    }


    public function render()
    {
        $services = Service::where('description_service', 'like', '%' . Str::lower($this->search) . '%')
            ->orderBy("id", 'asc')
            ->paginate(7);
        return view('livewire.service.index-service', compact('services'))
            ->layout('app');
    }

    // Preguntar Eliminar
    public function question($item)
    {
        $this->emit('question', [
            'title' => 'Eliminar el Servicio' . ' ' . ucwords($item['description_service']),
            'subtitle' => 'Se eliminará permanentemente', 'module' => 'service',
            'id' => $item['id']
        ]);
    }

    // Eliminar
    public function delete(Service $service)
    {
        $service->delete();
    }
}
