<?php

namespace App\Http\Livewire\Service;

use App\Models\Service;
use Livewire\Component;
use Illuminate\Support\Str;

class EditService extends Component
{
    public $service, $description_service, $status_service;

    protected $messages = [
        'description_service.required' => 'La descripción del servicio no puede estar vacio',
        'description_service.unique' => 'La descripción del servicio ya existe',
        'description_service.max' => 'La descripción del servicio maximo son 100 carácteres'
    ];

    public function rules()
    {
        return  [
            'description_service' => "required|max:100|unique:services,description_service," . optional($this->service)->id,
            'status_service' => 'required'
        ];
    }

    public function updated($propertyName)
    {
        $this->validateOnly($propertyName);
    }

    public function mount(Service $service)
    {
        $this->service = $service;
        $this->description_service = $service->description_service;
        $this->status_service = $service->status_service;
    }

    public function render()
    {
        return view('livewire.service.edit-service');
    }

    // Actualizar
    public function update()
    {
        $this->description_service = Str::lower($this->description_service); //HEORKU
        $this->validate();
        $this->service->update([
            'description_service' => Str::lower($this->description_service),
            'status_service' => $this->status_service
        ]);
        $this->emitTo('service.index-service', 'render');
        $this->emit('notify', 'Servicio Actualizado');
    }
}
