<?php

namespace App\Http\Livewire\Service;

use App\Models\Service;
use Livewire\Component;
use Illuminate\Support\Str;

class CreateService extends Component
{
    public $description_service, $status_service = '1';

    protected $rules = [
        'description_service' => 'required|unique:services,description_service|max:100',
        'status_service' => 'required'
    ];

    public function updated($propertyName)
    {
        $this->validateOnly($propertyName);
    }

    protected $messages = [
        'description_service.required' => 'La descripción del servicio no puede estar vacio',
        'description_service.unique' => 'La descripción del servicio ya existe',
        'description_service.max' => 'La descripción del servicio maximo son 100 carácteres'
    ];

    public function render()
    {
        return view('livewire.service.create-service');
    }

    // Guardar
    public function save()
    {
        $this->description_service = Str::lower($this->description_service); //HEORKU
        $this->validate();
        Service::create([
            'description_service' => Str::lower($this->description_service),
            'status_service' => $this->status_service
        ]);
        $this->reset(['description_service', 'status_service']);
        $this->emitTo('service.index-service', 'render');
        $this->emit('notify', 'Servicio Agregado');
    }
}
