<?php

namespace App\Http\Livewire\Sale;

use App\Models\Advance;
use App\Models\BankAccount;
use App\Models\DebtReminder;
use App\Models\Notification;
use App\Models\Order;
use App\Models\Sale;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Livewire\Component;

class ShowSale extends Component
{
    public $sale, $total_sale = 0,  $total_discount_sale = 0,  $observation_sale,
        $km, $car_id, $client_id, $sale_status_id, $bank_account_id;
    public $car, $client, $discount;
    public $date_debt;
    public $total_products = 0, $total_services = 0, $total_advances = 0, $total_pay = 0;
    public $order_description, $order_type = 'Servicio';
    protected $listeners = ['render', 'cancel', 'pay', 'debt'];

    public function mount(Sale $sale)
    {
        $this->sale = $sale;
        $this->total_discount_sale = $sale->total_discount_sale;
        $this->observation_sale = $sale->observation_sale;
        $this->km = $sale->km;
        $this->sale_status_id = $sale->sale_status_id;
        $this->car_id = $sale->car_id;
        $this->client_id = $sale->client_id;
        $this->car = $sale->Car;
        $this->client = $sale->Client;
        $this->bank_account_id = $sale->bank_account_id;
    }
    public function render()
    {
        $banks = BankAccount::where('open', '1')->get();
        $services = DB::table('sale_service')
            ->join('sales', 'sales.id', '=', 'sale_service.sale_id')
            ->join('services', 'services.id', '=', 'sale_service.service_id')
            ->where('sale_id', $this->sale->id)
            ->select('sale_service.*', 'services.description_service')
            ->get();
        $products = DB::table('product_sale')
            ->join('sales', 'sales.id', '=', 'product_sale.sale_id')
            ->join('products', 'products.id', '=', 'product_sale.product_id')
            ->where('sale_id', $this->sale->id)
            ->select('product_sale.*', 'products.description_product')
            ->get();

        $advances = Advance::with(['BankAccount'])->where('sale_id', $this->sale->id)->get();


        $this->total_sale = $services->sum('price_sale_service');
        foreach ($products as $product) {
            $this->total_sale += $product->amount_product_sale *
                $product->price_product_sale;
        }

        return view('livewire.sale.show-sale', compact('services', 'products', 'advances', 'banks'))
            ->layout('app');
    }

    // Actualizar
    public function update()
    {
        $this->sale->update([
            'km' => $this->km,
            'observation_sale' => $this->observation_sale,
            'total_discount_sale' => $this->total_discount_sale
        ]);
        $this->emit('notify', 'Detalles Actualizados');
    }


    // Cancelar Venta
    public function questionCancel()
    {
        $this->emit('question', [
            'title' => 'Seguro que desea cancelar esta Venta?',
            'subtitle' => 'Se cancelará esta venta', 'module' => 'cancelsale'
        ]);
    }
    public function cancel()
    {
        $this->sale->update([
            'condition_id' =>  3
        ]);
        return redirect()->route('sale.show', $this->sale);
    }

    // Pagar Venta

    public function questionPay()
    {
        $this->emit('question', [
            'title' => 'Realizar el pago de la Venta?',
            'subtitle' => 'Se realizará el pago', 'module' => 'paysale'
        ]);
    }

    public function pay()
    {
        $this->sale->update([
            'condition_id' => 2,
            'km' => $this->km,
            'observation_sale' => $this->observation_sale,
            'total_sale' => $this->total_sale,
            'total_discount_sale' => $this->total_discount_sale
        ]);
        return redirect()->route('sale.show', $this->sale);
    }


    public function debt()
    {
        if ($this->date_debt) {
            DebtReminder::create([
                'message' => 'Pago pendiente del Cliente: ' . ucwords($this->car->Client->names) . ', Venta N°: ' . $this->sale->id,
                'date' => $this->date_debt,
                'sale_id' => $this->sale->id,
            ]);
            $this->sale->update([
                'condition_id' => 4,
                'km' => $this->km,
                'observation_sale' => $this->observation_sale,
                'total_discount_sale' => $this->total_discount_sale
            ]);
            $this->emitTo('debt.count-debt', 'render');
            $this->emit('notify', 'Venta Marcada como DEUDA');
            return redirect()->route('sale.show', $this->sale);
        } else {
            $this->emit('error', ['title' => 'No se ingreso una fecha de pago']);
        }
    }
    // Imprimir Reporte
    public function printPDF()
    {
        return redirect()->route('pdf.sale', $this->sale);
    }

    public function changePayment()
    {
        $this->sale->update([
            'bank_account_id' => $this->bank_account_id
        ]);
        $this->emitSelf('render');
        $this->emit('notify', 'Método de pago cambiado');
    }

    public function discountSale()
    {
        $this->sale->update([
            'total_discount_sale' => $this->discount
        ]);
        $this->total_discount_sale = $this->discount;
        $this->emitSelf('render');
        $this->emit('notify', 'Descuento asignado');
    }

    public function addOrder()
    {
        if ($this->order_description) {
            Order::create([
                'order_description' => $this->order_description,
                'order_type' => $this->order_type,
                'sale_id' => $this->sale->id,
                'user_id' =>  Auth::user()->id
            ]);
            $this->reset(['order_type', 'order_description']);
            $this->emit('notify', 'Se emitió la orden');
        } else {
            $this->emit('error', ['title' => 'Descripción vacia']);
        }
    }
}
