<?php

namespace App\Http\Livewire\Sale;

use App\Models\Order;
use App\Models\Report;
use Livewire\Component;
use Livewire\WithPagination;

class ReportSale extends Component
{
    use WithPagination;
    public $sale, $title = 'REPORTES';

    protected $listeners = ['render'];

    public function mount($sale)
    {
        $this->sale = $sale;
    }

    public function render()
    {
        $reports = Report::where('sale_id', $this->sale->id)
            ->latest()
            ->paginate(5);
        $orders = Order::where('sale_id', $this->sale->id)
            ->orderBy('id', 'asc')
            ->paginate(5);
        return view('livewire.sale.report-sale', compact('reports', 'orders'));
    }
}
