<?php

namespace App\Http\Livewire\Sale;

use App\Models\Condition;
use App\Models\Sale;
use Livewire\Component;
use Livewire\WithPagination;
use Illuminate\Support\Str;

class IndexSale extends Component
{
    use WithPagination;
    public $status = 1, $search;
    protected $listeners = ['render'];
    public function render()
    {

        $sale_statuses = Condition::orderBy('id', 'asc')->pluck('description', 'id');
        $sales = Sale::with(['Client', 'Car', 'BankAccount', 'Condition'])
            ->orWhereHas('Car', function ($query) {
                $query->where('plate', 'like', '%' . Str::lower($this->search) . '%');
            })
            ->orWhereHas('Client', function ($query) {
                $query->where('dni', 'like', '%' . Str::lower($this->search) . '%');
            })
            ->orWhereHas('Client', function ($query) {
                $query->where('names', 'like', '%' . Str::lower($this->search) . '%');
            })
            ->where('condition_id', $this->status)
            ->orderBy('id', 'desc')
            ->paginate(7);

        return view('livewire.sale.index-sale', compact('sales', 'sale_statuses'))
            ->layout('app');
    }
}
